/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import invtweaks.api.container.ChestContainer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.inventory.InventoryPersonalChest;
import mekanism.common.inventory.container.ContainerMekanism;
import mekanism.common.inventory.slot.SlotPersonalChest;
import mekanism.common.tile.TileEntityPersonalChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

@ChestContainer(isLargeChest=true)
public class ContainerPersonalChest
extends ContainerMekanism<TileEntityPersonalChest> {
    private IInventory itemInventory;
    private boolean isBlock;

    public ContainerPersonalChest(InventoryPlayer inventory, TileEntityPersonalChest tile) {
        super(tile, inventory);
        this.itemInventory = null;
        this.isBlock = true;
        this.addAndOpen(inventory);
    }

    public ContainerPersonalChest(InventoryPlayer inventory, IInventory inv) {
        super(null, inventory);
        this.itemInventory = inv;
        this.isBlock = false;
        this.addAndOpen(inventory);
    }

    private void addAndOpen(InventoryPlayer inventory) {
        this.addSlots();
        this.addInventorySlots(inventory);
        this.openInventory(inventory);
    }

    @Override
    protected boolean shouldAddSlots() {
        return false;
    }

    @Override
    protected void addSlots() {
        for (int slotY = 0; slotY < 6; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.func_75146_a(new SlotPersonalChest(this.getInv(), slotX + slotY * 9, 8 + slotX * 18, 26 + slotY * 18));
            }
        }
    }

    @Override
    protected int getInventorYOffset() {
        return 148;
    }

    @Override
    protected void closeInventory(EntityPlayer entityplayer) {
        if (this.isBlock) {
            ((TileEntityPersonalChest)this.tileEntity).close(entityplayer);
            ((TileEntityPersonalChest)this.tileEntity).func_174886_c(entityplayer);
        } else {
            this.itemInventory.func_174886_c(entityplayer);
        }
    }

    @Override
    protected void openInventory(InventoryPlayer inventory) {
        if (this.isBlock) {
            ((TileEntityPersonalChest)this.tileEntity).open(inventory.field_70458_d);
            ((TileEntityPersonalChest)this.tileEntity).func_174889_b(inventory.field_70458_d);
        } else {
            this.itemInventory.func_174889_b(inventory.field_70458_d);
        }
    }

    public IInventory getInv() {
        if (this.isBlock) {
            return this.tileEntity;
        }
        return this.itemInventory;
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean func_75145_c(@Nonnull EntityPlayer entityplayer) {
        if (this.isBlock) {
            return super.func_75145_c(entityplayer);
        }
        ItemStack currentItem = entityplayer.func_184614_ca();
        IInventory iInventory = this.itemInventory;
        if (iInventory instanceof InventoryPersonalChest) {
            InventoryPersonalChest chest = (InventoryPersonalChest)iInventory;
            ItemStack stack = chest.getStack();
            return super.func_75145_c(entityplayer) && !stack.func_190926_b() && currentItem == stack && BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.PERSONAL_CHEST;
        }
        return false;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot currentSlot = (Slot)this.field_75151_b.get(slotID);
        if (currentSlot != null && currentSlot.func_75216_d()) {
            ItemStack slotStack = currentSlot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (slotID < 54 ? !this.func_75135_a(slotStack, 54, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, 54, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                currentSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                currentSlot.func_75218_e();
            }
            if (slotStack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            currentSlot.func_190901_a(player, slotStack);
        }
        return stack;
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, EntityPlayer player) {
        ItemStack itemStack;
        int hotbarSlotId = slotId - 81;
        if (!this.isBlock && hotbarSlotId >= 0 && hotbarSlotId < 9 && player.field_71071_by.field_70461_c == hotbarSlotId && !(itemStack = player.field_71071_by.func_70301_a(hotbarSlotId)).func_190926_b() && BlockStateMachine.MachineType.get(itemStack) == BlockStateMachine.MachineType.PERSONAL_CHEST) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }
}

