/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.common.base.IFactory;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.inventory.container.ContainerMekanism;
import mekanism.common.inventory.slot.SlotEnergy;
import mekanism.common.inventory.slot.SlotOutput;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.inputs.NucleosynthesizerInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerFactory
extends ContainerMekanism<TileEntityFactory> {
    public ContainerFactory(InventoryPlayer inventory, TileEntityFactory tile) {
        super(tile, inventory);
    }

    @Override
    protected void addSlots() {
        int i;
        int xOffset;
        this.func_75146_a(new SlotEnergy.SlotDischarge((IInventory)this.tileEntity, 1, 7, 13));
        int xTypeSlot = ((TileEntityFactory)this.tileEntity).tier == FactoryTier.CREATIVE ? 252 : (((TileEntityFactory)this.tileEntity).tier == FactoryTier.ULTIMATE ? 214 : 180);
        this.func_75146_a(new Slot((IInventory)this.tileEntity, 2, xTypeSlot, 75){

            public boolean func_75214_a(ItemStack stack) {
                BlockStateMachine.MachineType swapType = BlockStateMachine.MachineType.get(stack);
                return swapType != null && !swapType.isFactory();
            }
        });
        this.func_75146_a(new SlotOutput((IInventory)this.tileEntity, 3, xTypeSlot, 112));
        this.func_75146_a(new FactoryExtraSlot((IInventory)this.tileEntity, 4, 7, 57){});
        int n = ((TileEntityFactory)this.tileEntity).tier == FactoryTier.BASIC ? 55 : (((TileEntityFactory)this.tileEntity).tier == FactoryTier.ADVANCED ? 35 : (xOffset = ((TileEntityFactory)this.tileEntity).tier == FactoryTier.ELITE ? 29 : 27));
        int xDistance = ((TileEntityFactory)this.tileEntity).tier == FactoryTier.BASIC ? 38 : (((TileEntityFactory)this.tileEntity).tier == FactoryTier.ADVANCED ? 26 : 19);
        for (i = 0; i < ((TileEntityFactory)this.tileEntity).tier.processes; ++i) {
            if (((TileEntityFactory)this.tileEntity).NoItemInputMachine()) {
                this.func_75146_a(new FactoryInputSlot((IInventory)this.tileEntity, this.getInputSlotIndex(i), 7, 35, i, false, false));
                continue;
            }
            this.func_75146_a(new FactoryInputSlot((IInventory)this.tileEntity, this.getInputSlotIndex(i), xOffset + i * xDistance, 13, i, true, true));
        }
        for (i = 0; i < ((TileEntityFactory)this.tileEntity).tier.processes; ++i) {
            if (((TileEntityFactory)this.tileEntity).GasOutputMachine()) {
                this.func_75146_a(new FactoryOutputSlot((IInventory)this.tileEntity, this.getOutputSlotIndex(i), 7, 35, false));
                continue;
            }
            this.func_75146_a(new FactoryOutputSlot((IInventory)this.tileEntity, this.getOutputSlotIndex(i), xOffset + i * xDistance, 57, true));
        }
        for (i = 0; i < ((TileEntityFactory)this.tileEntity).tier.processes; ++i) {
            if (((TileEntityFactory)this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.FARM || ((TileEntityFactory)this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.CHANCE) {
                this.func_75146_a(new FactoryOutputSlot((IInventory)this.tileEntity, this.getSecondaryOutputSlotIndex(i), xOffset + i * xDistance, 78, true));
                continue;
            }
            this.func_75146_a(new FactoryOutputSlot((IInventory)this.tileEntity, this.getSecondaryOutputSlotIndex(i), 7, 35, false){});
        }
    }

    @Override
    protected int getInventorYOffset() {
        if (((TileEntityFactory)this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.ADVANCED || ((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.INFUSING || ((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.Dissolution || ((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.WASHER || ((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.NUCLEOSYNTHESIZER) {
            return 95;
        }
        if (((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.PRC) {
            return 113;
        }
        if (((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.Crystallizer) {
            return 91;
        }
        if (((TileEntityFactory)this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.FARM) {
            return 116;
        }
        if (((TileEntityFactory)this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.CHANCE) {
            return 105;
        }
        return 84;
    }

    @Override
    protected int getInventorXOffset() {
        return ((TileEntityFactory)this.tileEntity).tier == FactoryTier.CREATIVE ? 44 : (((TileEntityFactory)this.tileEntity).tier == FactoryTier.ULTIMATE ? 27 : 8);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot currentSlot = (Slot)this.field_75151_b.get(slotID);
        if (currentSlot != null && currentSlot.func_75216_d()) {
            int slotEnd;
            ItemStack slotStack = currentSlot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (this.isOutputSlot(slotID) ? !this.func_75135_a(slotStack, ((TileEntityFactory)this.tileEntity).inventory.size() - 1, this.field_75151_b.size(), true) : (this.isSecondaryOutputSlot(slotID) ? !this.func_75135_a(slotStack, ((TileEntityFactory)this.tileEntity).inventory.size() - 1, this.field_75151_b.size(), true) : (slotID != 1 && slotID != 2 && this.isProperMachine(slotStack) && !ItemHandlerHelper.canItemStacksStack((ItemStack)slotStack, (ItemStack)((TileEntityFactory)this.tileEntity).getMachineStack()) ? !this.func_75135_a(slotStack, 1, 2, false) : (slotID == 2 ? !this.func_75135_a(slotStack, ((TileEntityFactory)this.tileEntity).inventory.size() - 1, this.field_75151_b.size(), true) : (((TileEntityFactory)this.tileEntity).getRecipeType().getAnyRecipe(slotStack, ((Slot)this.field_75151_b.get(4)).func_75211_c(), ((TileEntityFactory)this.tileEntity).gasTank.getGasType(), ((TileEntityFactory)this.tileEntity).infuseStored, ((TileEntityFactory)this.tileEntity).gasTank.getGas(), ((TileEntityFactory)this.tileEntity).fluidTank.getFluid()) != null ? (this.isInputSlot(slotID) ? !this.func_75135_a(slotStack, ((TileEntityFactory)this.tileEntity).inventory.size() - 1, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 4, 4 + ((TileEntityFactory)this.tileEntity).tier.processes, false)) : (ChargeUtils.canBeDischarged(slotStack) ? (slotID == 0 ? !this.func_75135_a(slotStack, ((TileEntityFactory)this.tileEntity).inventory.size() - 1, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, 1, false)) : (((TileEntityFactory)this.tileEntity).getItemGas(slotStack) != null ? this.transferExtraSlot(slotID, slotStack) : (((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.INFUSING && InfuseRegistry.getObject(slotStack) != null && (((TileEntityFactory)this.tileEntity).infuseStored.getType() == null || ((TileEntityFactory)this.tileEntity).infuseStored.getType() == InfuseRegistry.getObject((ItemStack)slotStack).type) ? this.transferExtraSlot(slotID, slotStack) : (slotID >= (slotEnd = ((TileEntityFactory)this.tileEntity).inventory.size() - 1) && slotID <= slotEnd + 26 ? !this.func_75135_a(slotStack, slotEnd + 27, this.field_75151_b.size(), false) : (slotID > slotEnd + 26 ? !this.func_75135_a(slotStack, slotEnd, slotEnd + 26, false) : !this.func_75135_a(slotStack, slotEnd, this.field_75151_b.size(), true))))))))))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                currentSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                currentSlot.func_75218_e();
            }
            if (slotStack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            currentSlot.func_190901_a(player, slotStack);
        }
        return stack;
    }

    private boolean transferExtraSlot(int slotID, ItemStack slotStack) {
        if (slotID >= ((TileEntityFactory)this.tileEntity).inventory.size() - 1) {
            return !this.func_75135_a(slotStack, 3, 4, false);
        }
        return !this.func_75135_a(slotStack, ((TileEntityFactory)this.tileEntity).inventory.size() - 1, this.field_75151_b.size(), true);
    }

    public boolean isProperMachine(ItemStack itemStack) {
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemBlockMachine) {
            for (IFactory.RecipeType type : IFactory.RecipeType.values()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)type.getStack())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInputSlot(int slot) {
        return slot >= 4 && slot < 4 + ((TileEntityFactory)this.tileEntity).tier.processes;
    }

    public boolean isOutputSlot(int slot) {
        return slot >= 4 + ((TileEntityFactory)this.tileEntity).tier.processes && slot < 4 + ((TileEntityFactory)this.tileEntity).tier.processes * 2;
    }

    public boolean isSecondaryOutputSlot(int slot) {
        return slot >= 4 + ((TileEntityFactory)this.tileEntity).tier.processes * 2 && slot < 4 + ((TileEntityFactory)this.tileEntity).tier.processes * 3;
    }

    private int getOutputSlotIndex(int processNumber) {
        return ((TileEntityFactory)this.tileEntity).tier.processes + this.getInputSlotIndex(processNumber);
    }

    private int getSecondaryOutputSlotIndex(int processNumber) {
        return ((TileEntityFactory)this.tileEntity).tier.processes * 2 + this.getInputSlotIndex(processNumber);
    }

    private int getInputSlotIndex(int processNumber) {
        return 5 + processNumber;
    }

    private class FactoryInputSlot
    extends Slot {
        private final int processNumber;
        public boolean itemValid;
        public boolean enabled;

        private FactoryInputSlot(IInventory inventoryIn, int index, int xPosition, int yPosition, int processNumber, boolean itemValid, boolean enabled) {
            super(inventoryIn, index, xPosition, yPosition);
            this.processNumber = processNumber;
            this.itemValid = itemValid;
            this.enabled = enabled;
        }

        public boolean func_75214_a(ItemStack stack) {
            ItemStack inputSlotStack = (ItemStack)((TileEntityFactory)ContainerFactory.this.tileEntity).inventory.get(ContainerFactory.this.getOutputSlotIndex(this.processNumber));
            return this.isInputItem(stack);
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return this.enabled;
        }

        private boolean isInputItem(ItemStack itemstack) {
            if (!((TileEntityFactory)ContainerFactory.this.tileEntity).NoItemInputMachine()) {
                for (Object obj : ((TileEntityFactory)ContainerFactory.this.tileEntity).getRecipeType().getrecipe().get().entrySet()) {
                    Object stack;
                    MachineInput input;
                    Object k = ((Map.Entry)obj).getKey();
                    if (k instanceof AdvancedMachineInput) {
                        input = (AdvancedMachineInput)k;
                        stack = ((AdvancedMachineInput)input).itemStack;
                        if (ItemHandlerHelper.canItemStacksStack(stack, (ItemStack)itemstack)) {
                            return true;
                        }
                    }
                    if ((stack = ((Map.Entry)obj).getKey()) instanceof ItemStackInput) {
                        input = (ItemStackInput)stack;
                        stack = ((ItemStackInput)input).ingredient;
                        if (StackUtils.equalsWildcardWithNBT(stack, itemstack)) {
                            return true;
                        }
                    }
                    if ((stack = ((Map.Entry)obj).getKey()) instanceof DoubleMachineInput) {
                        input = (DoubleMachineInput)stack;
                        stack = ((DoubleMachineInput)input).itemStack;
                        if (ItemHandlerHelper.canItemStacksStack(stack, (ItemStack)itemstack)) {
                            return true;
                        }
                    }
                    if ((stack = ((Map.Entry)obj).getKey()) instanceof InfusionInput) {
                        input = (InfusionInput)stack;
                        stack = ((InfusionInput)input).inputStack;
                        if (ItemHandlerHelper.canItemStacksStack(stack, (ItemStack)itemstack)) {
                            return true;
                        }
                    }
                    if ((stack = ((Map.Entry)obj).getKey()) instanceof NucleosynthesizerInput && ItemHandlerHelper.canItemStacksStack(stack = ((NucleosynthesizerInput)(input = (NucleosynthesizerInput)stack)).getSolid(), (ItemStack)itemstack)) {
                        return true;
                    }
                    stack = ((Map.Entry)obj).getKey();
                    if (!(stack instanceof PressurizedInput) || !ItemHandlerHelper.canItemStacksStack(stack = ((PressurizedInput)(input = (PressurizedInput)stack)).getSolid(), (ItemStack)itemstack)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    private class FactoryOutputSlot
    extends SlotOutput {
        public boolean Enabled;

        public FactoryOutputSlot(IInventory inventory, int index, int x, int y, boolean enabled) {
            super(inventory, index, x, y);
            this.Enabled = enabled;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return this.Enabled;
        }
    }

    private class FactoryExtraSlot
    extends Slot {
        public FactoryExtraSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return ((TileEntityFactory)ContainerFactory.this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.DOUBLE || ((TileEntityFactory)ContainerFactory.this.tileEntity).getRecipeType() == IFactory.RecipeType.INFUSING || ((TileEntityFactory)ContainerFactory.this.tileEntity).GasAdvancedInputMachine() || ((TileEntityFactory)ContainerFactory.this.tileEntity).GasInputMachine();
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return ((TileEntityFactory)ContainerFactory.this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.DOUBLE || ((TileEntityFactory)ContainerFactory.this.tileEntity).getRecipeType() == IFactory.RecipeType.INFUSING || ((TileEntityFactory)ContainerFactory.this.tileEntity).GasAdvancedInputMachine() || ((TileEntityFactory)ContainerFactory.this.tileEntity).GasInputMachine();
        }
    }
}

