/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory;

import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tier.BinTier;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryBin {
    public ItemStack bin;

    public InventoryBin(ItemStack stack) {
        this.bin = stack;
    }

    public ItemStack getStack() {
        if (this.getItemCount() > 0 && !this.getItemType().func_190926_b()) {
            ItemStack ret = this.getItemType().func_77946_l();
            ret.func_190920_e(Math.min(this.getItemType().func_77976_d(), this.getItemCount()));
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack removeStack() {
        if (!MekanismConfig.current().mekce.BinRecipeRemovesItem.val()) {
            ItemStack stack = this.getStack();
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (this.getTier() != BinTier.CREATIVE) {
                this.setItemCount(this.getItemCount() - stack.func_190916_E());
            }
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack add(ItemStack stack) {
        if (this.isValid(stack) && (this.getTier() == BinTier.CREATIVE || this.getItemCount() != this.getMaxStorage())) {
            if (this.getItemType().func_190926_b()) {
                this.setItemType(stack);
            }
            if (this.getTier() != BinTier.CREATIVE) {
                if (this.getItemCount() + stack.func_190916_E() <= this.getMaxStorage()) {
                    this.setItemCount(this.getItemCount() + stack.func_190916_E());
                    return ItemStack.field_190927_a;
                }
                ItemStack rejects = this.getItemType().func_77946_l();
                rejects.func_190920_e(this.getItemCount() + stack.func_190916_E() - this.getMaxStorage());
                this.setItemCount(this.getMaxStorage());
                return rejects;
            }
            this.setItemCount(Integer.MAX_VALUE);
        }
        return stack;
    }

    public boolean isValid(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() <= 0 || BlockStateBasic.BasicBlockType.get(stack) == BlockStateBasic.BasicBlockType.BIN) {
            return false;
        }
        if (this.getItemType().func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.getItemType());
    }

    public int getMaxStorage() {
        return this.getTier().getStorage();
    }

    public BinTier getTier() {
        return BinTier.values()[((ITierItem)this.bin.func_77973_b()).getBaseTier(this.bin).ordinal()];
    }

    public int getItemCount() {
        return ItemDataUtils.getInt(this.bin, "itemCount");
    }

    public void setItemCount(int count) {
        ItemDataUtils.setInt(this.bin, "itemCount", Math.max(0, count));
        if (this.getItemCount() == 0) {
            this.setItemType(ItemStack.field_190927_a);
        }
    }

    public ItemStack getItemType() {
        if (this.getItemCount() == 0) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(ItemDataUtils.getCompound(this.bin, "storedItem"));
    }

    public void setItemType(ItemStack stack) {
        if (stack.func_190926_b()) {
            ItemDataUtils.removeData(this.bin, "storedItem");
            return;
        }
        ItemDataUtils.setCompound(this.bin, "storedItem", StackUtils.size(stack, 1).func_77955_b(new NBTTagCompound()));
    }
}

