/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.multipart;

import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.IPartSlot;
import mekanism.common.MekanismBlocks;
import mekanism.common.tier.BaseTier;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultipartTransmitter
implements IMultipart {
    public IPartSlot getSlotForPlacement(World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        return EnumCenterSlot.CENTER;
    }

    public IPartSlot getSlotFromWorld(IBlockAccess world, BlockPos pos, IBlockState state) {
        return EnumCenterSlot.CENTER;
    }

    public void onAdded(IPartInfo part) {
        TileEntity tile = part.getTile().getTileEntity();
        if (tile instanceof TileEntitySidedPipe) {
            TileEntitySidedPipe pipe = (TileEntitySidedPipe)tile;
            pipe.onAdded();
        }
    }

    public void onPartAdded(IPartInfo part, IPartInfo otherPart) {
        TileEntity tile = part.getTile().getTileEntity();
        if (tile instanceof TileEntitySidedPipe) {
            TileEntitySidedPipe pipe = (TileEntitySidedPipe)tile;
            tile.func_145829_t();
            pipe.notifyTileChange();
        }
    }

    public void onPartChanged(IPartInfo part, IPartInfo otherPart) {
        TileEntity tile = part.getTile().getTileEntity();
        if (tile instanceof TileEntitySidedPipe) {
            TileEntitySidedPipe pipe = (TileEntitySidedPipe)tile;
            pipe.onPartChanged(otherPart.getPart());
        }
    }

    public void onPartHarvested(IPartInfo part, EntityPlayer player) {
        TileEntity tile = part.getTile().getTileEntity();
        if (tile instanceof TileEntitySidedPipe) {
            IBlockState partState = part.getState();
            partState.func_177230_c().removedByPlayer(partState, part.getPartWorld(), part.getContainer().getPartPos(), player, true);
        }
        super.onPartHarvested(part, player);
    }

    public void onPartPlacedBy(IPartInfo part, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = part.getTile().getTileEntity();
        if (tile instanceof TileEntitySidedPipe) {
            TileEntitySidedPipe pipe = (TileEntitySidedPipe)tile;
            BaseTier baseTier = BaseTier.BASIC;
            if (stack.func_77942_o()) {
                baseTier = BaseTier.values()[stack.func_77978_p().func_74762_e("tier")];
            }
            pipe.setBaseTier(baseTier);
        }
    }

    public Block getBlock() {
        return MekanismBlocks.Transmitter;
    }
}

