/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.multipart;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IMultipartBlockAccess;
import mekanism.api.TileNetworkList;
import mekanism.common.base.ITileNetwork;
import mekanism.common.integration.multipart.MultipartMekanism;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultipartTileNetworkJoiner
implements ITileNetwork {
    private final Int2ObjectMap<ITileNetwork> tileSideMap = new Int2ObjectArrayMap(7);

    public MultipartTileNetworkJoiner(List<ITileNetwork> tileList) {
        IMultipartContainer container = null;
        TileEntity first = (TileEntity)tileList.get(0);
        World world = first.func_145831_w();
        if (world instanceof IMultipartBlockAccess) {
            IMultipartBlockAccess access = (IMultipartBlockAccess)world;
            container = access.getPartInfo().getContainer();
        } else {
            TileEntity worldTile = first.func_145831_w().func_175625_s(first.func_174877_v());
            if (worldTile instanceof IMultipartContainer) {
                IMultipartContainer containers;
                container = containers = (IMultipartContainer)worldTile;
            }
        }
        if (container != null) {
            for (IPartSlot slot : container.getParts().keySet()) {
                byte by;
                int tileIndex;
                Optional partTile = container.getPartTile(slot);
                if (!partTile.isPresent() || (tileIndex = tileList.indexOf(((IMultipartTile)partTile.get()).getTileEntity())) < 0) continue;
                if (slot instanceof EnumFaceSlot) {
                    EnumFaceSlot enumFaceSlot = (EnumFaceSlot)slot;
                    by = (byte)enumFaceSlot.ordinal();
                } else {
                    by = 6;
                }
                int slotValue = by;
                this.tileSideMap.put(slotValue, (Object)tileList.get(tileIndex));
            }
        }
    }

    public static void addMultipartHeader(TileEntity entity, TileNetworkList data, EnumFacing facing) {
        int tileNetworkParts = 0;
        IMultipartContainer container = MultipartMekanism.getContainer((IBlockAccess)entity.func_145831_w(), entity.func_174877_v());
        if (container != null) {
            IPartSlot slot;
            TileEntity part;
            Iterator iterator = container.getParts().keySet().iterator();
            while (iterator.hasNext() && (!((part = (TileEntity)container.getPartTile(slot = (IPartSlot)iterator.next()).map(IMultipartTile::getTileEntity).orElse(null)) instanceof ITileNetwork) || ++tileNetworkParts <= 1)) {
            }
        }
        if (tileNetworkParts > 1) {
            data.add(0, (byte)(facing == null ? 6 : facing.ordinal()));
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        byte side;
        ITileNetwork networkTile;
        while (dataStream.readableBytes() > 0 && (networkTile = (ITileNetwork)this.tileSideMap.get((int)(side = dataStream.readByte()))) != null) {
            networkTile.handlePacketData(dataStream);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        TileNetworkList childData = new TileNetworkList();
        IntIterator iterator = this.tileSideMap.keySet().iterator();
        while (iterator.hasNext()) {
            int slotValue = iterator.nextInt();
            ((ITileNetwork)this.tileSideMap.get(slotValue)).getNetworkedData(childData);
            data.addAll((Collection)((Object)childData));
            childData.clear();
        }
        return data;
    }
}

