/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.ic2;

import ic2.api.item.IElectricItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.integration.ic2.IC2Integration;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class IC2ItemManager
implements IElectricItemManager {
    public IEnergizedItem energizedItem;

    public static IC2ItemManager getManager(IEnergizedItem item) {
        IC2ItemManager manager = new IC2ItemManager();
        manager.energizedItem = item;
        return manager;
    }

    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (itemStack.func_190916_E() > 1) {
            return 0.0;
        }
        if (this.energizedItem.canReceive(itemStack)) {
            double energyNeeded = this.energizedItem.getMaxEnergy(itemStack) - this.energizedItem.getEnergy(itemStack);
            double energyToStore = Math.min(Math.min(IC2Integration.fromEU(amount), this.energizedItem.getMaxEnergy(itemStack) * 0.01), energyNeeded);
            if (!simulate) {
                this.energizedItem.setEnergy(itemStack, this.energizedItem.getEnergy(itemStack) + energyToStore);
            }
            return IC2Integration.toEU(energyToStore);
        }
        return 0.0;
    }

    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean external, boolean simulate) {
        if (itemStack.func_190916_E() > 1) {
            return 0.0;
        }
        if (this.energizedItem.canSend(itemStack)) {
            double energyWanted = IC2Integration.fromEU(amount);
            double energyToGive = Math.min(Math.min(energyWanted, this.energizedItem.getMaxEnergy(itemStack) * 0.01), this.energizedItem.getEnergy(itemStack));
            if (!simulate) {
                this.energizedItem.setEnergy(itemStack, this.energizedItem.getEnergy(itemStack) - energyToGive);
            }
            return IC2Integration.toEU(energyToGive);
        }
        return 0.0;
    }

    public boolean canUse(ItemStack itemStack, double amount) {
        return this.energizedItem.getEnergy(itemStack) >= IC2Integration.fromEU(amount);
    }

    public double getCharge(ItemStack itemStack) {
        return IC2Integration.toEU(this.energizedItem.getEnergy(itemStack));
    }

    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        return false;
    }

    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
    }

    public String getToolTip(ItemStack itemStack) {
        return null;
    }

    public double getMaxCharge(ItemStack stack) {
        return 0.0;
    }

    public int getTier(ItemStack stack) {
        return 4;
    }
}

