/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.ic2;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

public class IC2Integration {
    public static double toEU(double joules) {
        return joules * MekanismConfig.current().general.TO_IC2.val();
    }

    public static int toEUAsInt(double joules) {
        return MekanismUtils.clampToInt(IC2Integration.toEU(joules));
    }

    public static double fromEU(double eu) {
        return eu * MekanismConfig.current().general.FROM_IC2.val();
    }

    @Optional.Method(modid="ic2")
    public static boolean isOutputter(TileEntity tileEntity, EnumFacing side) {
        IEnergySource source;
        IEnergyTile tile = EnergyNet.instance.getSubTile(tileEntity.func_145831_w(), tileEntity.func_174877_v());
        return tile instanceof IEnergySource && (source = (IEnergySource)tile).emitsEnergyTo(null, side.func_176734_d());
    }

    @Optional.Method(modid="ic2")
    public static boolean isAcceptor(TileEntity tileEntity, EnumFacing side) {
        IEnergyTile tile = EnergyNet.instance.getSubTile(tileEntity.func_145831_w(), tileEntity.func_174877_v());
        if (tile instanceof IEnergySink) {
            IEnergySink sink = (IEnergySink)tile;
            return sink.acceptsEnergyFrom(null, side.func_176734_d());
        }
        return false;
    }
}

