/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.groovyscript.machinerecipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.mods.mekanism.Smelting;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.SmeltingRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;

public class Smelter
extends Smelting {
    private static boolean removedRecipe = false;
    private static boolean addedRecipe = false;

    public static boolean hasRemovedRecipe() {
        return removedRecipe;
    }

    public static boolean hasAddedRecipe() {
        return addedRecipe;
    }

    public SmeltingRecipe add(IIngredient ingredient, ItemStack output) {
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error adding Mekanism Smelter recipe", (Object[])new Object[0]).error();
        msg.add(IngredientHelper.isEmpty((IIngredient)ingredient), () -> "input must not be empty");
        msg.add(IngredientHelper.isEmpty((ItemStack)output), () -> "output must not be empty");
        if (msg.postIfNotEmpty()) {
            return null;
        }
        output = output.func_77946_l();
        SmeltingRecipe recipe1 = null;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            SmeltingRecipe recipe = new SmeltingRecipe(new ItemStackInput(itemStack.func_77946_l()), new ItemStackOutput(output));
            if (recipe1 == null) {
                recipe1 = recipe;
            }
            this.recipeRegistry.put(recipe);
            this.addScripted(recipe);
            addedRecipe = true;
        }
        return recipe1;
    }

    public boolean removeByInput(IIngredient ingredient) {
        if (IngredientHelper.isEmpty((IIngredient)ingredient)) {
            this.removeError("input must not be empty", new Object[0]);
            return false;
        }
        boolean found = false;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            SmeltingRecipe recipe = (SmeltingRecipe)this.recipeRegistry.get().remove((Object)new ItemStackInput(itemStack));
            if (recipe == null) continue;
            this.addBackup(recipe);
            found = true;
            removedRecipe = true;
        }
        if (!found) {
            this.removeError("could not find recipe for {}", new Object[]{ingredient});
        }
        return found;
    }
}

