/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.groovyscript.machinerecipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.VirtualizedMekanismRegistry;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import mekanism.common.integration.groovyscript.GrSMekanismAdd;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.RollingRecipe;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Rolling
extends VirtualizedMekanismRegistry<RollingRecipe> {
    public Rolling() {
        super(RecipeHandler.Recipe.ROLLING);
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    public RollingRecipe add(IIngredient ingredient, ItemStack output) {
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error adding Mekanism Rolling recipe", (Object[])new Object[0]).error();
        msg.add(IngredientHelper.isEmpty((IIngredient)ingredient), () -> "input must not be empty");
        msg.add(IngredientHelper.isEmpty((ItemStack)output), () -> "output must not be empty");
        if (msg.postIfNotEmpty()) {
            return null;
        }
        output = output.func_77946_l();
        RollingRecipe recipe1 = null;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            RollingRecipe recipe = new RollingRecipe(itemStack.func_77946_l(), output);
            if (recipe1 == null) {
                recipe1 = recipe;
            }
            this.recipeRegistry.put(recipe);
            this.addScripted(recipe);
        }
        return recipe1;
    }

    public boolean removeByInput(IIngredient ingredient) {
        if (IngredientHelper.isEmpty((IIngredient)ingredient)) {
            this.removeError("input must not be empty", new Object[0]);
            return false;
        }
        boolean found = false;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            RollingRecipe recipe = (RollingRecipe)this.recipeRegistry.get().remove((Object)new ItemStackInput(itemStack));
            if (recipe == null) continue;
            this.addBackup(recipe);
            found = true;
        }
        if (!found) {
            this.removeError("could not find recipe for %s", new Object[]{ingredient});
        }
        return found;
    }

    public static class RecipeBuilder
    extends AbstractRecipeBuilder<RollingRecipe> {
        public String getErrorMsg() {
            return "Error adding Mekanism Rolling recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 1, 1, 1, 1);
            this.validateFluids(msg);
        }

        @Nullable
        public RollingRecipe register() {
            if (!this.validate()) {
                return null;
            }
            RollingRecipe recipe = null;
            for (ItemStack itemStack : ((IIngredient)this.input.get(0)).getMatchingStacks()) {
                RollingRecipe r = new RollingRecipe(itemStack.func_77946_l(), (ItemStack)this.output.get(0));
                if (recipe == null) {
                    recipe = r;
                }
                GrSMekanismAdd.get().rolling.add(r);
            }
            return recipe;
        }
    }
}

