/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.groovyscript.machinerecipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.mods.mekanism.Mekanism;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.GasRecipeBuilder;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.VirtualizedMekanismRegistry;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.groovyscript.GrSMekanismAdd;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.FarmRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class OrganicFarm
extends VirtualizedMekanismRegistry<FarmRecipe> {
    public OrganicFarm() {
        super(RecipeHandler.Recipe.ORGANIC_FARM);
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    public FarmRecipe add(IIngredient ingredient, GasStack gasInput, ItemStack output) {
        return this.add(ingredient, gasInput, output, null, 0.0);
    }

    public FarmRecipe add(IIngredient ingredient, GasStack gasInput, ItemStack output, ItemStack secondary) {
        return this.add(ingredient, gasInput, output, secondary, 1.0);
    }

    public FarmRecipe add(IIngredient ingredient, GasStack gasInput, ItemStack output, ItemStack secondary, double chance) {
        boolean withSecondary;
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error adding Mekanism Organic Farm recipe", (Object[])new Object[0]).error();
        msg.add(IngredientHelper.isEmpty((IIngredient)ingredient), () -> "input must not be empty");
        msg.add(Mekanism.isEmpty((GasStack)gasInput), () -> "input must not be empty");
        msg.add(IngredientHelper.isEmpty((ItemStack)output), () -> "output must not be empty");
        if (msg.postIfNotEmpty()) {
            return null;
        }
        boolean bl = withSecondary = !IngredientHelper.isEmpty((ItemStack)secondary);
        if (withSecondary) {
            if (chance <= 0.0) {
                chance = 1.0;
            }
            secondary = secondary.func_77946_l();
        }
        output = output.func_77946_l();
        FarmRecipe recipe1 = null;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            ChanceOutput chanceOutput = withSecondary ? new ChanceOutput(output, secondary, chance) : new ChanceOutput(output);
            FarmRecipe recipe = new FarmRecipe(new AdvancedMachineInput(itemStack.func_77946_l(), gasInput.getGas()), chanceOutput);
            if (recipe1 == null) {
                recipe1 = recipe;
            }
            this.recipeRegistry.put(recipe);
            this.addScripted(recipe);
        }
        return recipe1;
    }

    public boolean removeByInput(IIngredient inputSolid, GasStack inputGas) {
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error removing Mekanism Organic Farm recipe", (Object[])new Object[0]).error();
        msg.add(IngredientHelper.isEmpty((IIngredient)inputSolid), () -> "input must not be empty");
        msg.add(Mekanism.isEmpty((GasStack)inputGas), () -> "gas input must not be empty");
        if (msg.postIfNotEmpty()) {
            return false;
        }
        boolean found = false;
        for (ItemStack itemStack : inputSolid.getMatchingStacks()) {
            FarmRecipe recipe = (FarmRecipe)this.recipeRegistry.get().remove((Object)new AdvancedMachineInput(itemStack, inputGas.getGas()));
            if (recipe == null) continue;
            this.addBackup(recipe);
            found = true;
        }
        if (!found) {
            this.removeError("could not find recipe for {} and {}", new Object[]{inputSolid, inputGas});
        }
        return found;
    }

    public static class RecipeBuilder
    extends GasRecipeBuilder<FarmRecipe> {
        private ItemStack extra = ItemStack.field_190927_a;
        private double chance = 1.0;

        public RecipeBuilder extra(ItemStack extra) {
            this.extra = extra;
            return this;
        }

        public RecipeBuilder chance(double chance) {
            this.chance = chance;
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Mekanism Organic Farm recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 1, 1, 1, 1);
            this.validateFluids(msg);
            this.validateGases(msg, 1, 1, 0, 0);
            msg.add(this.chance < 0.0 || this.chance > 1.0, "chance must be between 0 and 1.0, yet it was {}", new Object[]{this.chance});
        }

        @Nullable
        public FarmRecipe register() {
            if (!this.validate()) {
                return null;
            }
            ChanceOutput chanceOutput = this.extra.func_190926_b() ? new ChanceOutput((ItemStack)this.output.get(0)) : new ChanceOutput((ItemStack)this.output.get(0), this.extra, this.chance);
            FarmRecipe recipe = null;
            for (ItemStack itemStack : ((IIngredient)this.input.get(0)).getMatchingStacks()) {
                FarmRecipe r = new FarmRecipe(new AdvancedMachineInput(itemStack.func_77946_l(), ((GasStack)this.gasInput.get(0)).getGas()), chanceOutput);
                if (recipe == null) {
                    recipe = r;
                }
                GrSMekanismAdd.get().organicFarm.add(r);
            }
            return recipe;
        }
    }
}

