/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.groovyscript.machinerecipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.mods.mekanism.Mekanism;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.GasRecipeBuilder;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.VirtualizedMekanismRegistry;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.groovyscript.GrSMekanismAdd;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.NutritionalRecipe;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class NutritionalLiquifier
extends VirtualizedMekanismRegistry<NutritionalRecipe> {
    public NutritionalLiquifier() {
        super(RecipeHandler.Recipe.NUTRITIONAL_LIQUIFIER);
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    public NutritionalRecipe add(IIngredient ingredient, GasStack output) {
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error adding Mekanism Nutritional Liquifier recipe", (Object[])new Object[0]).error();
        msg.add(IngredientHelper.isEmpty((IIngredient)ingredient), () -> "input must not be empty");
        msg.add(Mekanism.isEmpty((GasStack)output), () -> "output must not be empty");
        if (msg.postIfNotEmpty()) {
            return null;
        }
        output = output.copy();
        NutritionalRecipe recipe1 = null;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            NutritionalRecipe recipe = new NutritionalRecipe(itemStack.func_77946_l(), output);
            if (recipe1 == null) {
                recipe1 = recipe;
            }
            this.recipeRegistry.put(recipe);
            this.addScripted(recipe);
        }
        return recipe1;
    }

    public boolean removeByInput(IIngredient ingredient) {
        if (IngredientHelper.isEmpty((IIngredient)ingredient)) {
            this.removeError("input must not be empty", new Object[0]);
            return false;
        }
        boolean found = false;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            NutritionalRecipe recipe = (NutritionalRecipe)this.recipeRegistry.get().remove((Object)new ItemStackInput(itemStack));
            if (recipe == null) continue;
            this.addBackup(recipe);
            found = true;
        }
        if (!found) {
            this.removeError("could not find recipe for {}", new Object[]{ingredient});
        }
        return found;
    }

    public static class RecipeBuilder
    extends GasRecipeBuilder<NutritionalRecipe> {
        public String getErrorMsg() {
            return "Error adding Mekanism Nutritional Liquifier recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 1, 1, 0, 0);
            this.validateFluids(msg);
            this.validateGases(msg, 0, 0, 1, 1);
        }

        @Nullable
        public NutritionalRecipe register() {
            if (!this.validate()) {
                return null;
            }
            NutritionalRecipe recipe = null;
            for (ItemStack itemStack : ((IIngredient)this.input.get(0)).getMatchingStacks()) {
                NutritionalRecipe r = new NutritionalRecipe(itemStack.func_77946_l(), (GasStack)this.gasOutput.get(0));
                if (recipe == null) {
                    recipe = r;
                }
                GrSMekanismAdd.get().nutritionalLiquifier.add(r);
            }
            return recipe;
        }
    }
}

