/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.groovyscript.machinerecipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.compat.mods.mekanism.Mekanism;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.GasRecipeBuilder;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.VirtualizedMekanismRegistry;
import com.cleanroommc.groovyscript.helper.Alias;
import java.util.Collection;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.groovyscript.GrSMekanismAdd;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.IsotopicRecipe;
import org.jetbrains.annotations.Nullable;

public class IsotopicCentrifuge
extends VirtualizedMekanismRegistry<IsotopicRecipe> {
    public IsotopicCentrifuge() {
        super(RecipeHandler.Recipe.ISOTOPIC_CENTRIFUGE, (Collection)Alias.generateOf((String)"IsotopicCentrifuge").and(new String[]{"Isotopic_Centrifuge"}));
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    public IsotopicRecipe add(GasStack input, GasStack output) {
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error adding Mekanism Isotopic Centrifuge recipe", (Object[])new Object[0]).error();
        msg.add(Mekanism.isEmpty((GasStack)input), () -> "input must not be empty");
        msg.add(Mekanism.isEmpty((GasStack)output), () -> "output must not be empty");
        if (msg.postIfNotEmpty()) {
            return null;
        }
        IsotopicRecipe recipe = new IsotopicRecipe(input.copy(), output.copy());
        this.recipeRegistry.put(recipe);
        this.addScripted(recipe);
        return recipe;
    }

    public boolean removeByInput(GasStack input) {
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error removing Mekanism Isotopic Centrifuge recipe", (Object[])new Object[0]).error();
        msg.add(Mekanism.isEmpty((GasStack)input), () -> "input must not be empty");
        if (msg.postIfNotEmpty()) {
            return false;
        }
        IsotopicRecipe recipe = (IsotopicRecipe)this.recipeRegistry.get().remove((Object)new GasInput(input));
        if (recipe != null) {
            this.addBackup(recipe);
            return true;
        }
        this.removeError("could not find recipe for %", new Object[]{input});
        return false;
    }

    public static class RecipeBuilder
    extends GasRecipeBuilder<IsotopicRecipe> {
        public String getErrorMsg() {
            return "Error adding Mekanism Isotopic Centrifuge recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg);
            this.validateFluids(msg);
            this.validateGases(msg, 1, 1, 1, 1);
        }

        @Nullable
        public IsotopicRecipe register() {
            if (!this.validate()) {
                return null;
            }
            IsotopicRecipe recipe = new IsotopicRecipe((GasStack)this.gasInput.get(0), (GasStack)this.gasOutput.get(0));
            GrSMekanismAdd.get().isotopicCentrifuge.add(recipe);
            return recipe;
        }
    }
}

