/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.groovyscript.machinerecipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.VirtualizedMekanismRegistry;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import mekanism.common.integration.groovyscript.GrSMekanismAdd;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.CellSeparatorRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CellSeparator
extends VirtualizedMekanismRegistry<CellSeparatorRecipe> {
    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    public CellSeparator() {
        super(RecipeHandler.Recipe.CELL_SEPARATOR);
    }

    public CellSeparatorRecipe add(IIngredient ingredient, ItemStack output) {
        return this.add(ingredient, output, null, 0.0);
    }

    public CellSeparatorRecipe add(IIngredient ingredient, ItemStack output, ItemStack secondary) {
        return this.add(ingredient, output, secondary, 1.0);
    }

    public CellSeparatorRecipe add(IIngredient ingredient, ItemStack output, ItemStack secondary, double chance) {
        boolean withSecondary;
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error adding Mekanism Cell Separator recipe", (Object[])new Object[0]).error();
        msg.add(IngredientHelper.isEmpty((IIngredient)ingredient), () -> "input must not be empty");
        msg.add(IngredientHelper.isEmpty((ItemStack)output), () -> "output must not be empty");
        if (msg.postIfNotEmpty()) {
            return null;
        }
        boolean bl = withSecondary = !IngredientHelper.isEmpty((ItemStack)secondary);
        if (withSecondary) {
            if (chance <= 0.0) {
                chance = 1.0;
            }
            secondary = secondary.func_77946_l();
        }
        output = output.func_77946_l();
        CellSeparatorRecipe recipe1 = null;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            ChanceOutput chanceOutput = withSecondary ? new ChanceOutput(output, secondary, chance) : new ChanceOutput(output);
            CellSeparatorRecipe recipe = new CellSeparatorRecipe(new ItemStackInput(itemStack.func_77946_l()), chanceOutput);
            if (recipe1 == null) {
                recipe1 = recipe;
            }
            this.recipeRegistry.put(recipe);
            this.addScripted(recipe);
        }
        return recipe1;
    }

    public boolean removeByInput(IIngredient ingredient) {
        if (IngredientHelper.isEmpty((IIngredient)ingredient)) {
            this.removeError("input must not be empty", new Object[0]);
            return false;
        }
        boolean found = false;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            CellSeparatorRecipe recipe = (CellSeparatorRecipe)this.recipeRegistry.get().remove((Object)new ItemStackInput(itemStack));
            if (recipe == null) continue;
            this.addBackup(recipe);
            found = true;
        }
        if (!found) {
            this.removeError("could not find recipe for %s", new Object[]{ingredient});
        }
        return found;
    }

    public static class RecipeBuilder
    extends AbstractRecipeBuilder<CellSeparatorRecipe> {
        private ItemStack extra = ItemStack.field_190927_a;
        private double chance = 1.0;

        public RecipeBuilder extra(ItemStack extra) {
            this.extra = extra;
            return this;
        }

        public RecipeBuilder chance(double chance) {
            this.chance = chance;
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Mekanism Cell Separator recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 1, 1, 1, 1);
            this.validateFluids(msg);
            msg.add(this.chance < 0.0 || this.chance > 1.0, "chance must be between 0 and 1.0, yet it was {}", new Object[]{this.chance});
        }

        @Nullable
        public CellSeparatorRecipe register() {
            if (!this.validate()) {
                return null;
            }
            ChanceOutput chanceOutput = this.extra.func_190926_b() ? new ChanceOutput((ItemStack)this.output.get(0)) : new ChanceOutput((ItemStack)this.output.get(0), this.extra, this.chance);
            CellSeparatorRecipe recipe = null;
            for (ItemStack itemStack : ((IIngredient)this.input.get(0)).getMatchingStacks()) {
                CellSeparatorRecipe r = new CellSeparatorRecipe(new ItemStackInput(itemStack.func_77946_l()), chanceOutput);
                if (recipe == null) {
                    recipe = r;
                }
                GrSMekanismAdd.get().cellSeparator.add(r);
            }
            return recipe;
        }
    }
}

