/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.groovyscript.machinerecipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.mods.mekanism.Mekanism;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.GasRecipeBuilder;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.VirtualizedMekanismRegistry;
import com.cleanroommc.groovyscript.helper.Alias;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import java.util.Collection;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.groovyscript.GrSMekanismAdd;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.NucleosynthesizerInput;
import mekanism.common.recipe.machines.NucleosynthesizerRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AntiprotonicNucleosynthesizer
extends VirtualizedMekanismRegistry<NucleosynthesizerRecipe> {
    public AntiprotonicNucleosynthesizer() {
        super(RecipeHandler.Recipe.ANTIPROTONIC_NUCLEOSYNTHESIZER, (Collection)Alias.generateOfClass(AntiprotonicNucleosynthesizer.class).and(new String[]{"AntiprotonicNucleosynthesizer", "antiprotonic_nucleosynthesizer"}));
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    public NucleosynthesizerRecipe add(IIngredient inputSolid, GasStack inputGas, ItemStack outputSolid, double energy, int duration) {
        NucleosynthesizerRecipe r = null;
        for (ItemStack item : inputSolid.getMatchingStacks()) {
            NucleosynthesizerRecipe recipe = new NucleosynthesizerRecipe(item, inputGas.copy(), outputSolid.func_77946_l(), energy, duration);
            if (r == null) {
                r = recipe;
            }
            this.recipeRegistry.put(recipe);
            this.addScripted(recipe);
        }
        return r;
    }

    public boolean removeByInput(IIngredient inputSolid, GasStack inputGas) {
        if (GroovyLog.msg((String)"Error removing Mekanism Antiprotonic Nucleosynthesizer recipe", (Object[])new Object[0]).error().add(IngredientHelper.isEmpty((IIngredient)inputSolid), () -> "item input must not be empty").add(Mekanism.isEmpty((GasStack)inputGas), () -> "input gas must not be empty").error().postIfNotEmpty()) {
            return false;
        }
        boolean found = false;
        for (ItemStack itemStack : inputSolid.getMatchingStacks()) {
            NucleosynthesizerRecipe recipe = (NucleosynthesizerRecipe)this.recipeRegistry.get().remove((Object)new NucleosynthesizerInput(itemStack, inputGas));
            if (recipe == null) continue;
            this.addBackup(recipe);
            found = true;
        }
        if (!found) {
            this.removeError("could not find recipe for %s and %s", new Object[]{inputSolid, inputGas});
        }
        return found;
    }

    public static class RecipeBuilder
    extends GasRecipeBuilder<NucleosynthesizerRecipe> {
        private int duration;
        private double energy;

        public RecipeBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public RecipeBuilder energy(double energy) {
            this.energy = energy;
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Mekanism Antiprotonic Nucleosynthesizer recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 0, 1, 1, 1);
            this.validateFluids(msg);
            this.validateGases(msg, 1, 1, 0, 0);
            if (this.duration <= 0) {
                this.duration = 100;
            }
            if (this.energy <= 0.0) {
                this.energy = 8000.0;
            }
        }

        @Nullable
        public NucleosynthesizerRecipe register() {
            if (!this.validate()) {
                return null;
            }
            ItemStackOutput itemStackOutput = new ItemStackOutput(this.output.getOrEmpty(0));
            NucleosynthesizerRecipe recipe = null;
            if (this.input.isEmpty()) {
                recipe = new NucleosynthesizerRecipe(new NucleosynthesizerInput(ItemStack.field_190927_a, (GasStack)this.gasInput.get(0)), itemStackOutput, this.energy, this.duration);
                GrSMekanismAdd.get().antiprotonicNucleosynthesizer.add(recipe);
            } else {
                for (ItemStack itemStack : ((IIngredient)this.input.get(0)).getMatchingStacks()) {
                    NucleosynthesizerRecipe r = new NucleosynthesizerRecipe(new NucleosynthesizerInput(itemStack.func_77946_l(), (GasStack)this.gasInput.get(0)), itemStackOutput, this.energy, this.duration);
                    if (recipe == null) {
                        recipe = r;
                    }
                    GrSMekanismAdd.get().antiprotonicNucleosynthesizer.add(r);
                }
            }
            return recipe;
        }
    }
}

