/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.groovyscript.machinerecipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.compat.mods.mekanism.Mekanism;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.GasRecipeBuilder;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.VirtualizedMekanismRegistry;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.groovyscript.GrSMekanismAdd;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.IntegerInput;
import mekanism.common.recipe.machines.AmbientGasRecipe;
import mekanism.common.recipe.outputs.ChanceGasOutput;
import org.jetbrains.annotations.Nullable;

public class AmbientAccumulator
extends VirtualizedMekanismRegistry<AmbientGasRecipe> {
    public AmbientAccumulator() {
        super(RecipeHandler.Recipe.AMBIENT_ACCUMULATOR);
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    public AmbientGasRecipe add(int dim, GasStack output) {
        return this.add(dim, output, 1.0);
    }

    public AmbientGasRecipe add(int dim, GasStack output, double chane) {
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error adding Mekanism Ambient Accumulator recipe", (Object[])new Object[0]).error();
        msg.add(Mekanism.isEmpty((GasStack)output), () -> "output must not be empty");
        if (msg.postIfNotEmpty()) {
            return null;
        }
        AmbientGasRecipe recipe = new AmbientGasRecipe(dim, output.copy(), chane);
        this.recipeRegistry.put(recipe);
        this.addScripted(recipe);
        return recipe;
    }

    public boolean removeByInput(int dim) {
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error removing Mekanism Ambient Accumulator recipe", (Object[])new Object[0]).error();
        if (msg.postIfNotEmpty()) {
            return false;
        }
        boolean found = false;
        AmbientGasRecipe recipe = (AmbientGasRecipe)this.recipeRegistry.get().remove((Object)new IntegerInput(dim));
        if (recipe != null) {
            this.addBackup(recipe);
            found = true;
        }
        if (!found) {
            this.removeError("could not find recipe for %", new Object[]{dim});
        }
        return found;
    }

    public static class RecipeBuilder
    extends GasRecipeBuilder<AmbientGasRecipe> {
        private int dim;
        private double chance;

        public RecipeBuilder dim(int dim) {
            this.dim = dim;
            return this;
        }

        public RecipeBuilder chance(double chance) {
            this.chance = chance;
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Mekanism Ambient Accumulator recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg);
            this.validateGases(msg, 0, 0, 1, 1);
            msg.add(this.chance <= -2.147483648E9 || this.chance >= 2.147483647E9, "dim must be between -2147483648 and 2147483647, yet it was {}", new Object[]{this.chance});
            msg.add(this.chance <= 0.0 || this.chance >= 1.0, "chance must be between 0 and 1.0, yet it was {}", new Object[]{this.chance});
        }

        @Nullable
        public AmbientGasRecipe register() {
            if (!this.validate()) {
                return null;
            }
            ChanceGasOutput chanceGasOutput = new ChanceGasOutput((GasStack)this.gasOutput.get(0), this.chance);
            IntegerInput input = new IntegerInput(this.dim);
            AmbientGasRecipe recipe = new AmbientGasRecipe(input, chanceGasOutput);
            GrSMekanismAdd.get().ambient.add(recipe);
            return recipe;
        }
    }
}

