/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.groovyscript.machinerecipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.mods.mekanism.recipe.VirtualizedMekanismRegistry;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import mekanism.common.integration.groovyscript.GrSMekanismAdd;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.machines.AlloyRecipe;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Alloy
extends VirtualizedMekanismRegistry<AlloyRecipe> {
    public Alloy() {
        super(RecipeHandler.Recipe.ALLOY);
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    public AlloyRecipe add(IIngredient ingredient, ItemStack extra, ItemStack output) {
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error adding Mekanism Alloy recipe", (Object[])new Object[0]).error();
        msg.add(IngredientHelper.isEmpty((IIngredient)ingredient), () -> "input must not be empty");
        msg.add(IngredientHelper.isEmpty((ItemStack)extra), () -> "extra input must not be empty");
        msg.add(IngredientHelper.isEmpty((ItemStack)output), () -> "output must not be empty");
        if (msg.postIfNotEmpty()) {
            return null;
        }
        extra = extra.func_77946_l();
        output = output.func_77946_l();
        AlloyRecipe recipe1 = null;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            AlloyRecipe recipe = new AlloyRecipe(itemStack.func_77946_l(), extra, output);
            if (recipe1 == null) {
                recipe1 = recipe;
            }
            this.recipeRegistry.put(recipe);
            this.addScripted(recipe);
        }
        return recipe1;
    }

    public boolean removeByInput(IIngredient ingredient, ItemStack extra) {
        GroovyLog.Msg msg = GroovyLog.msg((String)"Error removing Mekanism Alloy recipe", (Object[])new Object[0]).error();
        msg.add(IngredientHelper.isEmpty((IIngredient)ingredient), () -> "input must not be empty");
        msg.add(IngredientHelper.isEmpty((ItemStack)extra), () -> "extra input must not be empty");
        if (msg.postIfNotEmpty()) {
            return false;
        }
        boolean found = false;
        for (ItemStack itemStack : ingredient.getMatchingStacks()) {
            AlloyRecipe recipe = (AlloyRecipe)this.recipeRegistry.get().remove((Object)new DoubleMachineInput(itemStack, extra));
            if (recipe == null) continue;
            this.addBackup(recipe);
            found = true;
        }
        if (!found) {
            this.removeError("could not find recipe for %s and %s", new Object[]{ingredient, extra});
        }
        return found;
    }

    public static class RecipeBuilder
    extends AbstractRecipeBuilder<AlloyRecipe> {
        private ItemStack extra;

        public RecipeBuilder extra(ItemStack extra) {
            this.extra = extra;
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Mekanism Alloy recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 1, 1, 1, 1);
            this.validateFluids(msg);
        }

        @Nullable
        public AlloyRecipe register() {
            if (!this.validate()) {
                return null;
            }
            AlloyRecipe recipe = null;
            for (ItemStack itemStack : ((IIngredient)this.input.get(0)).getMatchingStacks()) {
                AlloyRecipe r = new AlloyRecipe(itemStack.func_77946_l(), this.extra, (ItemStack)this.output.get(0));
                if (recipe == null) {
                    recipe = r;
                }
                GrSMekanismAdd.get().alloy.add(r);
            }
            return recipe;
        }
    }
}

