/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.fluxnetworks;

import javax.annotation.Nonnull;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyOutputter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;

public class MekanismEnergyHandler
implements ITileEnergyHandler {
    public static final MekanismEnergyHandler INSTANCE = new MekanismEnergyHandler();

    public boolean hasCapability(@Nonnull TileEntity te, EnumFacing facing) {
        return this.canAddEnergy(te, facing) || this.canRemoveEnergy(te, facing);
    }

    public boolean canAddEnergy(@Nonnull TileEntity te, EnumFacing facing) {
        IStrictEnergyAcceptor acceptor;
        return te instanceof IStrictEnergyAcceptor && (acceptor = (IStrictEnergyAcceptor)te).canReceiveEnergy(facing);
    }

    public boolean canRemoveEnergy(@Nonnull TileEntity te, EnumFacing facing) {
        IStrictEnergyOutputter outputter;
        return te instanceof IStrictEnergyOutputter && (outputter = (IStrictEnergyOutputter)te).canOutputEnergy(facing);
    }

    public long addEnergy(long amount, @Nonnull TileEntity te, EnumFacing facing, boolean simulate) {
        if (te instanceof IStrictEnergyAcceptor) {
            IStrictEnergyAcceptor acceptor = (IStrictEnergyAcceptor)te;
            return (long)Math.ceil(acceptor.acceptEnergy(facing, (double)amount * 2.5, simulate) / 2.5);
        }
        return 0L;
    }

    public long removeEnergy(long amount, @Nonnull TileEntity te, EnumFacing facing) {
        if (te instanceof IStrictEnergyOutputter) {
            IStrictEnergyOutputter outputter = (IStrictEnergyOutputter)te;
            return (long)Math.ceil(outputter.pullEnergy(facing, (double)amount * 2.5, false) / 2.5);
        }
        return 0L;
    }
}

