/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.helpers;

import crafttweaker.mc1120.item.MCItemStack;
import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeInfoHelper {
    private RecipeInfoHelper() {
    }

    public static String getRecipeInfo(Map.Entry<? extends MachineInput<?>, ? extends MachineRecipe<?, ?, ?>> recipe) {
        Object output = recipe.getValue().recipeOutput;
        if (output instanceof ItemStackOutput) {
            ItemStackOutput stackOutput = (ItemStackOutput)output;
            return RecipeInfoHelper.getItemName(stackOutput.output);
        }
        if (output instanceof GasOutput) {
            GasOutput gasOutput = (GasOutput)output;
            return RecipeInfoHelper.getGasName(gasOutput.output);
        }
        if (output instanceof FluidOutput) {
            FluidOutput fluidOutput = (FluidOutput)output;
            return RecipeInfoHelper.getFluidName(fluidOutput.output);
        }
        if (output instanceof ChemicalPairOutput) {
            ChemicalPairOutput out = (ChemicalPairOutput)output;
            return "[" + RecipeInfoHelper.getGasName(out.leftGas) + ", " + RecipeInfoHelper.getGasName(out.rightGas) + "]";
        }
        if (output instanceof ChanceOutput) {
            ChanceOutput chanceOutput = (ChanceOutput)output;
            return RecipeInfoHelper.getItemName(chanceOutput.primaryOutput);
        }
        if (output instanceof PressurizedOutput) {
            PressurizedOutput out = (PressurizedOutput)output;
            return "[" + RecipeInfoHelper.getItemName(out.getItemOutput()) + ", " + RecipeInfoHelper.getGasName(out.getGasOutput()) + "]";
        }
        return null;
    }

    public static String getGasName(GasStack stack) {
        return stack.amount > 1 ? String.format("<gas:%s> * %s", stack.getGas().getName(), stack.amount) : RecipeInfoHelper.getGasName(stack.getGas());
    }

    public static String getGasName(Gas gas) {
        return String.format("<gas:%s>", gas.getName());
    }

    public static String getFluidName(FluidStack stack) {
        return stack.amount > 1 ? String.format("<liquid:%s> * %s", stack.getFluid().getName(), stack.amount) : RecipeInfoHelper.getFluidName(stack.getFluid());
    }

    public static String getFluidName(Fluid fluid) {
        return String.format("<liquid:%s>", fluid.getName());
    }

    public static String getItemName(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return "nothing";
        }
        return new MCItemStack(stack).toString();
    }
}

