/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.helpers;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.util.IngredientWrapper;
import mekanism.common.recipe.ingredients.IMekanismIngredient;
import mekanism.common.recipe.ingredients.IngredientMekIngredientWrapper;
import mekanism.common.recipe.ingredients.ItemStackMekIngredient;
import mekanism.common.recipe.ingredients.OredictMekIngredient;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.IntegerInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class IngredientHelper {
    private IngredientHelper() {
    }

    public static IIngredient optionalIngredient(IIngredient ingredient) {
        return ingredient != null ? ingredient : IngredientAny.INSTANCE;
    }

    public static boolean checkNotNull(String name, IIngredient ... ingredients) {
        for (IIngredient ingredient : ingredients) {
            if (ingredient != null) continue;
            CraftTweakerAPI.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return false;
        }
        return true;
    }

    private static IIngredient getIngredient(Object ingredient) {
        if (ingredient instanceof ItemStack) {
            ItemStack stack = (ItemStack)ingredient;
            return CraftTweakerMC.getIItemStack((ItemStack)stack);
        }
        if (ingredient instanceof GasStack) {
            GasStack stack = (GasStack)ingredient;
            return new CraftTweakerGasStack(stack);
        }
        if (ingredient instanceof Gas) {
            Gas gas = (Gas)ingredient;
            return new CraftTweakerGasStack(new GasStack(gas, 1));
        }
        if (ingredient instanceof FluidStack) {
            FluidStack stack = (FluidStack)ingredient;
            return CraftTweakerMC.getILiquidStack((FluidStack)stack);
        }
        if (ingredient instanceof Fluid) {
            Fluid fluid = (Fluid)ingredient;
            return CraftTweakerMC.getILiquidStack((FluidStack)new FluidStack(fluid, 1));
        }
        return IngredientAny.INSTANCE;
    }

    public static boolean matches(IIngredient input, IIngredient toMatch) {
        if (input instanceof IGasStack) {
            IGasStack stack = (IGasStack)input;
            return GasHelper.matches(toMatch, stack);
        }
        if (input instanceof IItemStack) {
            IItemStack stack = (IItemStack)input;
            return toMatch != null && toMatch.matches(stack);
        }
        if (input instanceof ILiquidStack) {
            ILiquidStack liquidStack = (ILiquidStack)input;
            return toMatch != null && toMatch.matches(liquidStack);
        }
        return false;
    }

    public static boolean matches(Object input, IIngredient toMatch) {
        return IngredientHelper.matches(IngredientHelper.getIngredient(input), toMatch);
    }

    public static <INPUT extends MachineInput<INPUT>> boolean matches(INPUT in, IngredientWrapper toMatch) {
        if (in instanceof ItemStackInput) {
            ItemStackInput input = (ItemStackInput)in;
            return IngredientHelper.matches(input.ingredient, toMatch.getIngredient());
        }
        if (in instanceof GasInput) {
            GasInput input = (GasInput)in;
            return IngredientHelper.matches(input.ingredient, toMatch.getIngredient());
        }
        if (in instanceof FluidInput) {
            FluidInput input = (FluidInput)in;
            return IngredientHelper.matches(input.ingredient, toMatch.getIngredient());
        }
        if (in instanceof AdvancedMachineInput) {
            AdvancedMachineInput input = (AdvancedMachineInput)in;
            return IngredientHelper.matches(input.itemStack, toMatch.getLeft()) && IngredientHelper.matches(input.gasType, toMatch.getRight());
        }
        if (in instanceof ChemicalPairInput) {
            ChemicalPairInput input = (ChemicalPairInput)in;
            return IngredientHelper.matches(input.leftGas, toMatch.getLeft()) && IngredientHelper.matches(input.rightGas, toMatch.getRight());
        }
        if (in instanceof DoubleMachineInput) {
            DoubleMachineInput input = (DoubleMachineInput)in;
            return IngredientHelper.matches(input.itemStack, toMatch.getLeft()) && IngredientHelper.matches(input.extraStack, toMatch.getRight());
        }
        if (in instanceof PressurizedInput) {
            PressurizedInput input = (PressurizedInput)in;
            return IngredientHelper.matches(input.getSolid(), toMatch.getLeft()) && IngredientHelper.matches(input.getFluid(), toMatch.getMiddle()) && IngredientHelper.matches(input.getGas(), toMatch.getRight());
        }
        if (in instanceof InfusionInput) {
            InfusionInput input = (InfusionInput)in;
            return IngredientHelper.matches(input.inputStack, toMatch.getIngredient()) && (toMatch.getInfuseType().isEmpty() || toMatch.getInfuseType().equalsIgnoreCase(input.infuse.getType().name));
        }
        if (in instanceof IntegerInput) {
            IntegerInput input = (IntegerInput)in;
            return input.ingredient == toMatch.getAmount();
        }
        return false;
    }

    public static <OUTPUT extends MachineOutput<OUTPUT>> boolean matches(OUTPUT out, IngredientWrapper toMatch) {
        if (out instanceof ItemStackOutput) {
            ItemStackOutput output = (ItemStackOutput)out;
            return IngredientHelper.matches(output.output, toMatch.getIngredient());
        }
        if (out instanceof GasOutput) {
            GasOutput output = (GasOutput)out;
            return IngredientHelper.matches(output.output, toMatch.getIngredient());
        }
        if (out instanceof FluidOutput) {
            FluidOutput output = (FluidOutput)out;
            return IngredientHelper.matches(output.output, toMatch.getIngredient());
        }
        if (out instanceof ChanceOutput) {
            ChanceOutput output = (ChanceOutput)out;
            return IngredientHelper.matches(output.primaryOutput, toMatch.getLeft()) && IngredientHelper.matches(output.secondaryOutput, toMatch.getRight());
        }
        if (out instanceof ChemicalPairOutput) {
            ChemicalPairOutput output = (ChemicalPairOutput)out;
            return IngredientHelper.matches(output.leftGas, toMatch.getLeft()) && IngredientHelper.matches(output.rightGas, toMatch.getRight());
        }
        if (out instanceof PressurizedOutput) {
            PressurizedOutput output = (PressurizedOutput)out;
            return IngredientHelper.matches(output.getItemOutput(), toMatch.getLeft()) && IngredientHelper.matches(output.getGasOutput(), toMatch.getRight());
        }
        return false;
    }

    public static IMekanismIngredient<ItemStack> getMekanismIngredient(IIngredient ingredient) {
        if (ingredient instanceof IOreDictEntry) {
            IOreDictEntry oreDictEntry = (IOreDictEntry)ingredient;
            return new OredictMekIngredient(oreDictEntry.getName());
        }
        if (ingredient instanceof IItemStack) {
            return new ItemStackMekIngredient(CraftTweakerMC.getItemStack((IIngredient)ingredient));
        }
        return new IngredientMekIngredientWrapper(CraftTweakerMC.getIngredient((IIngredient)ingredient));
    }

    public static FluidStack toFluid(ILiquidStack fluid) {
        return fluid == null ? null : FluidRegistry.getFluidStack((String)fluid.getName(), (int)fluid.getAmount());
    }
}

