/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.IngredientWrapper;
import mekanism.common.integration.crafttweaker.util.RemoveAllMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.RecyclerRecipe;
import mekanism.common.recipe.outputs.ChanceOutput2;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.recycler")
@ZenRegister
public class Recycler {
    public static final String NAME = "Mekanism Recycler";

    @ZenMethod
    public static void addRecipe(IIngredient ingredientInput, IItemStack optionalItemOutput, double optionalChance) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{ingredientInput, optionalItemOutput})) {
            ChanceOutput2 output = new ChanceOutput2(CraftTweakerMC.getItemStack((IItemStack)optionalItemOutput), optionalChance);
            ArrayList<RecyclerRecipe> recipes = new ArrayList<RecyclerRecipe>();
            for (ItemStack stack : CraftTweakerMC.getIngredient((IIngredient)ingredientInput).func_193365_a()) {
                recipes.add(new RecyclerRecipe(new ItemStackInput(stack), output));
            }
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<ItemStackInput, ChanceOutput2, RecyclerRecipe>(NAME, RecipeHandler.Recipe.RECYCLER, recipes));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemInput, IIngredient optionalItemOutput) {
        if (IngredientHelper.checkNotNull(NAME, itemInput)) {
            CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveMekanismRecipe<ItemStackInput, ChanceOutput2, RecyclerRecipe>(NAME, RecipeHandler.Recipe.RECYCLER, new IngredientWrapper(optionalItemOutput), new IngredientWrapper(itemInput)));
        }
    }

    @ZenMethod
    public static void removeAllRecipes() {
        CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveAllMekanismRecipe<ItemStackInput, ChanceOutput2, RecyclerRecipe>(NAME, RecipeHandler.Recipe.RECYCLER));
    }
}

