/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.IngredientWrapper;
import mekanism.common.integration.crafttweaker.util.RemoveAllMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.NucleosynthesizerInput;
import mekanism.common.recipe.machines.NucleosynthesizerRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.nucleosynthesizer")
@ZenRegister
public class Nucleosynthesizer {
    public static final String NAME = "Mekanism Nucleosynthesizer";

    @ZenMethod
    public static void addRecipe(IIngredient ingredientInput, IGasStack gasInput, IItemStack itemOutput, double energy, int duration) {
        if (IngredientHelper.checkNotNull(NAME, ingredientInput, gasInput)) {
            GasStack gas = GasHelper.toGas(gasInput);
            ItemStackOutput output = new ItemStackOutput(CraftTweakerMC.getItemStack((IItemStack)itemOutput));
            ArrayList<NucleosynthesizerRecipe> recipes = new ArrayList<NucleosynthesizerRecipe>();
            for (ItemStack stack : CraftTweakerMC.getIngredient((IIngredient)ingredientInput).func_193365_a()) {
                recipes.add(new NucleosynthesizerRecipe(new NucleosynthesizerInput(stack, gas), output, energy, duration));
            }
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<NucleosynthesizerInput, ItemStackOutput, NucleosynthesizerRecipe>(NAME, RecipeHandler.Recipe.ANTIPROTONIC_NUCLEOSYNTHESIZER, recipes));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient itemInput, @Optional IIngredient gasInput) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[0])) {
            CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveMekanismRecipe<NucleosynthesizerInput, ItemStackOutput, NucleosynthesizerRecipe>(NAME, RecipeHandler.Recipe.ANTIPROTONIC_NUCLEOSYNTHESIZER, new IngredientWrapper(itemOutput), new IngredientWrapper(itemInput, gasInput)));
        }
    }

    @ZenMethod
    public static void removeAllRecipes() {
        CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveAllMekanismRecipe<NucleosynthesizerInput, ItemStackOutput, NucleosynthesizerRecipe>(NAME, RecipeHandler.Recipe.ANTIPROTONIC_NUCLEOSYNTHESIZER));
    }
}

