/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.gas;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.minecraft.CraftTweakerMC;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasDefinition;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import net.minecraftforge.fluids.Fluid;

public class CraftTweakerGasDefinition
implements IGasDefinition {
    private final Gas gas;

    public CraftTweakerGasDefinition(Gas gas) {
        this.gas = gas;
    }

    @Override
    public IGasStack asStack(int mb) {
        return new CraftTweakerGasStack(new GasStack(this.gas, mb));
    }

    @Override
    public String getName() {
        return this.gas.getName();
    }

    @Override
    public String getDisplayName() {
        return this.gas.getLocalizedName();
    }

    @Override
    public ILiquidDefinition getLiquid() {
        return CraftTweakerMC.getILiquidDefinition((Fluid)this.gas.getFluid());
    }

    @Override
    public void setLiquid(ILiquidDefinition liquid) {
        CraftTweakerAPI.apply((IAction)new SetGasLiquidFormAction(this.gas, CraftTweakerMC.getFluid((ILiquidDefinition)liquid)));
    }

    @Override
    public int getTint() {
        return this.gas.getTint();
    }

    @Override
    public void setTint(int tint) {
        CraftTweakerAPI.apply((IAction)new SetGasTintAction(this.gas, tint));
    }

    public static class SetGasLiquidFormAction
    implements IAction {
        private final Gas gas;
        private final Fluid fluid;

        public SetGasLiquidFormAction(Gas gas, Fluid fluid) {
            this.gas = gas;
            this.fluid = fluid;
        }

        public void apply() {
            this.gas.setFluid(this.fluid);
        }

        public String describe() {
            return "Set the liquid form of " + this.gas.getName() + " to " + this.fluid.getName();
        }
    }

    public static class SetGasTintAction
    implements IAction {
        private final Gas gas;
        private final int tint;

        public SetGasTintAction(Gas gas, int tint) {
            this.gas = gas;
            this.tint = tint;
        }

        public void apply() {
            this.gas.setTint(this.tint);
        }

        public String describe() {
            return "Set tint of " + this.gas.getName() + " to #" + Integer.toHexString(this.tint);
        }
    }
}

