/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.multiblock.TileEntityInductionCell;
import mekanism.common.tile.multiblock.TileEntityInductionProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="mcp.mobius.waila.api.IWailaDataProvider", modid="Waila")
public class WailaDataProvider
implements IWailaDataProvider {
    @Optional.Method(modid="Waila")
    public static void register(IWailaRegistrar registrar) {
        WailaDataProvider provider = new WailaDataProvider();
        registrar.registerHeadProvider((IWailaDataProvider)provider, TileEntityInductionCell.class);
        registrar.registerHeadProvider((IWailaDataProvider)provider, TileEntityInductionProvider.class);
        registrar.registerHeadProvider((IWailaDataProvider)provider, TileEntityFactory.class);
        registrar.registerHeadProvider((IWailaDataProvider)provider, TileEntityBoundingBlock.class);
        registrar.registerHeadProvider((IWailaDataProvider)provider, TileEntityAdvancedBoundingBlock.class);
        registrar.registerHeadProvider((IWailaDataProvider)provider, TileEntityFluidTank.class);
        registrar.registerHeadProvider((IWailaDataProvider)provider, TileEntityGasTank.class);
        registrar.registerHeadProvider((IWailaDataProvider)provider, TileEntityBin.class);
        registrar.registerHeadProvider((IWailaDataProvider)provider, TileEntityEnergyCube.class);
    }

    @Nonnull
    @Optional.Method(modid="Waila")
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    @Optional.Method(modid="Waila")
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile = accessor.getTileEntity();
        if (tile instanceof TileEntityInductionCell) {
            TileEntityInductionCell cell = (TileEntityInductionCell)tile;
            currenttip.set(0, (Object)((Object)EnumColor.WHITE) + cell.getName());
        } else if (tile instanceof TileEntityInductionProvider) {
            TileEntityInductionProvider provider = (TileEntityInductionProvider)tile;
            currenttip.set(0, (Object)((Object)EnumColor.WHITE) + provider.getName());
        } else if (tile instanceof TileEntityFactory) {
            TileEntityFactory factory = (TileEntityFactory)tile;
            currenttip.set(0, (Object)((Object)EnumColor.WHITE) + factory.func_70005_c_());
        } else if (tile instanceof TileEntityFluidTank) {
            TileEntityFluidTank tank = (TileEntityFluidTank)tile;
            currenttip.set(0, (Object)((Object)EnumColor.WHITE) + tank.func_70005_c_());
        } else if (tile instanceof TileEntityGasTank) {
            TileEntityGasTank gasTank = (TileEntityGasTank)tile;
            currenttip.set(0, (Object)((Object)EnumColor.WHITE) + gasTank.func_70005_c_());
        } else if (tile instanceof TileEntityBin) {
            TileEntityBin bin = (TileEntityBin)tile;
            currenttip.set(0, (Object)((Object)EnumColor.WHITE) + bin.func_70005_c_());
        } else if (tile instanceof TileEntityEnergyCube) {
            TileEntityEnergyCube cube = (TileEntityEnergyCube)tile;
            currenttip.set(0, (Object)((Object)EnumColor.WHITE) + cube.func_70005_c_());
        } else if (tile instanceof TileEntityBoundingBlock) {
            TileEntity tileEntity;
            TileEntityBoundingBlock bound = (TileEntityBoundingBlock)tile;
            Coord4D coord = new Coord4D(bound.func_174877_v(), tile.func_145831_w());
            if (bound.receivedCoords && (tileEntity = coord.getTileEntity((IBlockAccess)tile.func_145831_w())) instanceof IInventory) {
                IInventory inventory = (IInventory)tileEntity;
                currenttip.set(0, (Object)((Object)EnumColor.WHITE) + inventory.func_70005_c_());
            }
        }
        return currenttip;
    }

    @Nonnull
    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    @Optional.Method(modid="Waila")
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    @Optional.Method(modid="Waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }
}

