/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class TOPProvider
implements Function<ITheOneProbe, Void>,
IProbeInfoProvider {
    @Override
    public Void apply(ITheOneProbe iTheOneProbe) {
        iTheOneProbe.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    public String getID() {
        return "mekanism";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        GasTankInfo[] tanks;
        if (!MekanismConfig.current().client.GasTOP.val() && mode != ProbeMode.EXTENDED) {
            return;
        }
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile == null || !tile.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, null)) {
            return;
        }
        IGasHandler handler = (IGasHandler)tile.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return;
        }
        for (GasTankInfo tank : tanks = handler.getTankInfo()) {
            IProgressStyle style = probeInfo.defaultProgressStyle().suffix("mB");
            if (tank.getGas() != null) {
                Gas gas = tank.getGas().getGas();
                probeInfo.text(TextStyleClass.NAME + I18n.func_74838_a((String)"gui.gas:") + gas.getLocalizedName());
                int tint = gas.getTint();
                if ((tint & 0xFF000000) == 0) {
                    tint = 0xFF000000 | tint;
                }
                if (tint != -1) {
                    int darkerTint = TOPProvider.darkenColor(tint, 0.8);
                    int lighterTint = TOPProvider.lightenColor(tint, 0.8);
                    style = style.filledColor(tint).alternateFilledColor(lighterTint).borderColor(darkerTint).numberFormat(NumberFormat.COMPACT);
                }
            }
            probeInfo.progress(tank.getStored(), tank.getMaxGas(), style);
        }
    }

    private static int darkenColor(int color, double factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((double)(color >> 16 & 0xFF) * factor);
        int g = (int)((double)(color >> 8 & 0xFF) * factor);
        int b = (int)((double)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int lightenColor(int color, double factor) {
        int a = color >> 24 & 0xFF;
        int r = Math.min(255, (int)((double)(color >> 16 & 0xFF) / factor));
        int g = Math.min(255, (int)((double)(color >> 8 & 0xFF) / factor));
        int b = Math.min(255, (int)((double)(color & 0xFF) / factor));
        return a << 24 | r << 16 | g << 8 | b;
    }
}

