/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.frequency;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.IFrequencyHandler;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class FrequencyManager {
    public static final int MAX_FREQ_LENGTH = 16;
    public static final List<Character> SPECIAL_CHARS = Arrays.asList(Character.valueOf('-'), Character.valueOf(' '), Character.valueOf('|'), Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('_'), Character.valueOf('+'), Character.valueOf(':'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('?'), Character.valueOf('!'), Character.valueOf('/'), Character.valueOf('@'), Character.valueOf('$'), Character.valueOf('`'), Character.valueOf('~'), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('#'));
    public static boolean loaded;
    private static Set<FrequencyManager> managers;
    private Int2ObjectMap<Frequency> frequencies = new Int2ObjectOpenHashMap();
    private FrequencyDataHandler dataHandler;
    private UUID ownerUUID;
    private String name;
    private Class<? extends Frequency> frequencyClass;

    public FrequencyManager(Class<? extends Frequency> c, String n) {
        this.frequencyClass = c;
        this.name = n;
        managers.add(this);
    }

    public FrequencyManager(Class<? extends Frequency> c, String n, UUID uuid) {
        this(c, n);
        this.ownerUUID = uuid;
    }

    public static void load(World world) {
        loaded = true;
        for (FrequencyManager manager : managers) {
            manager.createOrLoad(world);
        }
    }

    public static void tick(World world) {
        if (!loaded) {
            FrequencyManager.load(world);
        }
        managers.parallelStream().forEach(manager -> manager.tickSelf(world));
    }

    public static void reset() {
        for (FrequencyManager manager : managers) {
            manager.frequencies.clear();
            manager.dataHandler = null;
        }
        loaded = false;
    }

    public Frequency update(Coord4D coord, Frequency freq) {
        Frequency iterFreq = (Frequency)this.frequencies.get(freq.hashCode());
        if (iterFreq != null) {
            iterFreq.activeCoords.add(coord);
            this.dataHandler.func_76185_a();
            return iterFreq;
        }
        this.deactivate(coord);
        return null;
    }

    public void remove(String name, UUID owner) {
        Iterator<Frequency> iter = this.getFrequencies().iterator();
        while (iter.hasNext()) {
            Frequency iterFreq = iter.next();
            if (!iterFreq.name.equals(name) || !iterFreq.ownerUUID.equals(owner)) continue;
            iter.remove();
            this.dataHandler.func_76185_a();
        }
    }

    public void remove(String name) {
        Iterator<Frequency> iter = this.getFrequencies().iterator();
        while (iter.hasNext()) {
            Frequency iterFreq = iter.next();
            if (!iterFreq.name.equals(name)) continue;
            iter.remove();
            this.dataHandler.func_76185_a();
        }
    }

    public void deactivate(Coord4D coord) {
        for (Frequency freq : this.frequencies.values()) {
            freq.activeCoords.remove(coord);
            this.dataHandler.func_76185_a();
        }
    }

    public Frequency validateFrequency(UUID uuid, Coord4D coord, Frequency freq) {
        Frequency iterFreq = (Frequency)this.frequencies.get(freq.hashCode());
        if (iterFreq != null) {
            iterFreq.activeCoords.add(coord);
            this.dataHandler.func_76185_a();
            return iterFreq;
        }
        if (uuid.equals(freq.ownerUUID)) {
            freq.activeCoords.add(coord);
            freq.valid = true;
            this.frequencies.put(freq.hashCode(), (Object)freq);
            this.dataHandler.func_76185_a();
            return freq;
        }
        return null;
    }

    public void createOrLoad(World world) {
        String name = this.getName();
        if (this.dataHandler == null) {
            this.dataHandler = (FrequencyDataHandler)world.getPerWorldStorage().func_75742_a(FrequencyDataHandler.class, name);
            if (this.dataHandler == null) {
                this.dataHandler = new FrequencyDataHandler(name);
                this.dataHandler.setManager(this);
                world.getPerWorldStorage().func_75745_a(name, (WorldSavedData)this.dataHandler);
            } else {
                this.dataHandler.setManager(this);
                this.dataHandler.syncManager();
            }
        }
    }

    public Collection<Frequency> getFrequencies() {
        return this.frequencies.values();
    }

    public void addFrequency(Frequency freq) {
        this.frequencies.put(freq.hashCode(), (Object)freq);
        this.dataHandler.func_76185_a();
    }

    public boolean containsFrequency(String name) {
        for (Frequency freq : this.frequencies.values()) {
            if (!freq.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void tickSelf(World world) {
        this.frequencies.values().parallelStream().forEach(frequency -> {
            Iterator<Coord4D> it = frequency.activeCoords.iterator();
            while (it.hasNext()) {
                Coord4D coord = it.next();
                if (coord.dimensionId != world.field_73011_w.getDimension()) continue;
                if (!coord.exists(world)) {
                    it.remove();
                    continue;
                }
                TileEntity tile = coord.getTileEntity((IBlockAccess)world);
                if (!(tile instanceof IFrequencyHandler)) {
                    it.remove();
                    continue;
                }
                IFrequencyHandler handler = (IFrequencyHandler)tile;
                Frequency handlerFreq = handler.getFrequency(this);
                if (frequency.equals(handlerFreq)) continue;
                it.remove();
            }
        });
    }

    public void writeFrequencies(TileNetworkList data) {
        data.add(this.frequencies.size());
        for (Frequency freq : this.frequencies.values()) {
            freq.write(data);
        }
    }

    public Set<Frequency> readFrequencies(ByteBuf dataStream) {
        ObjectOpenHashSet ret = new ObjectOpenHashSet();
        int size = dataStream.readInt();
        try {
            for (int i = 0; i < size; ++i) {
                Frequency freq = this.frequencyClass.getConstructor(ByteBuf.class).newInstance(dataStream);
                freq.read(dataStream);
                ret.add(freq);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public String getName() {
        return this.ownerUUID != null ? this.ownerUUID.toString() + "_" + this.name + "FrequencyHandler" : this.name + "FrequencyHandler";
    }

    static {
        managers = new ReferenceOpenHashSet();
    }

    public static class FrequencyDataHandler
    extends WorldSavedData {
        public FrequencyManager manager;
        public Set<Frequency> loadedFrequencies;
        public UUID loadedOwner;

        public FrequencyDataHandler(String tagName) {
            super(tagName);
        }

        public void setManager(FrequencyManager m) {
            this.manager = m;
        }

        public void syncManager() {
            if (this.loadedFrequencies != null) {
                this.loadedFrequencies.forEach(frequency -> this.manager.frequencies.put(frequency.hashCode(), frequency));
                this.manager.ownerUUID = this.loadedOwner;
            }
        }

        public void func_76184_a(@Nonnull NBTTagCompound nbtTags) {
            try {
                String frequencyClass = nbtTags.func_74779_i("frequencyClass");
                if (nbtTags.func_74764_b("ownerUUID")) {
                    this.loadedOwner = UUID.fromString(nbtTags.func_74779_i("ownerUUID"));
                }
                NBTTagList list = nbtTags.func_150295_c("freqList", 10);
                this.loadedFrequencies = new ObjectOpenHashSet();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound compound = list.func_150305_b(i);
                    Constructor<?> c = Class.forName(frequencyClass).getConstructor(NBTTagCompound.class);
                    Frequency freq = (Frequency)c.newInstance(compound);
                    this.loadedFrequencies.add(freq);
                }
            }
            catch (ReflectiveOperationException e) {
                Mekanism.logger.error("Couldn't load frequency data", (Throwable)e);
            }
        }

        @Nonnull
        public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound nbtTags) {
            nbtTags.func_74778_a("frequencyClass", this.manager.frequencyClass.getName());
            if (this.manager.ownerUUID != null) {
                nbtTags.func_74778_a("ownerUUID", this.manager.ownerUUID.toString());
            }
            NBTTagList list = new NBTTagList();
            for (Frequency freq : this.manager.getFrequencies()) {
                NBTTagCompound compound = new NBTTagCompound();
                freq.write(compound);
                list.func_74742_a((NBTBase)compound);
            }
            nbtTags.func_74782_a("freqList", (NBTBase)list);
            return nbtTags;
        }
    }
}

