/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Pos3D;
import mekanism.common.MekanismSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBalloon
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Byte> IS_LATCHED = EntityDataManager.func_187226_a(EntityBalloon.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> LATCHED_X = EntityDataManager.func_187226_a(EntityBalloon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LATCHED_Y = EntityDataManager.func_187226_a(EntityBalloon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LATCHED_Z = EntityDataManager.func_187226_a(EntityBalloon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LATCHED_ID = EntityDataManager.func_187226_a(EntityBalloon.class, (DataSerializer)DataSerializers.field_187192_b);
    public EnumColor color = EnumColor.DARK_BLUE;
    public Coord4D latched;
    public EntityLivingBase latchedEntity;
    public boolean hasCachedEntity;
    public UUID cachedEntityUUID;

    public EntityBalloon(World world) {
        super(world);
        this.field_70158_ak = true;
        this.field_70156_m = true;
        this.func_70107_b(this.field_70165_t + 0.5, this.field_70163_u + 3.0, this.field_70161_v + 0.5);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70181_x = 0.04;
        this.field_70180_af.func_187214_a(IS_LATCHED, (Object)0);
        this.field_70180_af.func_187214_a(LATCHED_X, (Object)0);
        this.field_70180_af.func_187214_a(LATCHED_Y, (Object)0);
        this.field_70180_af.func_187214_a(LATCHED_Z, (Object)0);
        this.field_70180_af.func_187214_a(LATCHED_ID, (Object)-1);
    }

    public EntityBalloon(World world, double x, double y, double z, EnumColor c) {
        this(world);
        this.func_70107_b(x + 0.5, y + 3.0, z + 0.5);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.color = c;
    }

    public EntityBalloon(EntityLivingBase entity, EnumColor c) {
        this(entity.field_70170_p);
        this.latchedEntity = entity;
        this.func_70107_b(this.latchedEntity.field_70165_t, this.latchedEntity.field_70163_u + (double)this.latchedEntity.field_70131_O + (double)1.7f, this.latchedEntity.field_70161_v);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.color = c;
        this.field_70180_af.func_187227_b(IS_LATCHED, (Object)2);
        this.field_70180_af.func_187227_b(LATCHED_ID, (Object)entity.func_145782_y());
    }

    public EntityBalloon(World world, Coord4D obj, EnumColor c) {
        this(world);
        this.latched = obj;
        this.func_70107_b((float)this.latched.x + 0.5f, (float)this.latched.y + 1.9f, (float)this.latched.z + 0.5f);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.color = c;
        this.field_70180_af.func_187227_b(IS_LATCHED, (Object)1);
        this.field_70180_af.func_187227_b(LATCHED_X, (Object)(this.latched != null ? this.latched.x : 0));
        this.field_70180_af.func_187227_b(LATCHED_Y, (Object)(this.latched != null ? this.latched.y : 0));
        this.field_70180_af.func_187227_b(LATCHED_Z, (Object)(this.latched != null ? this.latched.z : 0));
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70163_u > 255.0) {
            this.pop();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.latched = (Byte)this.field_70180_af.func_187225_a(IS_LATCHED) == 1 ? new Coord4D(((Integer)this.field_70180_af.func_187225_a(LATCHED_X)).intValue(), ((Integer)this.field_70180_af.func_187225_a(LATCHED_Y)).intValue(), ((Integer)this.field_70180_af.func_187225_a(LATCHED_Z)).intValue(), this.field_70170_p.field_73011_w.getDimension()) : null;
            this.latchedEntity = (Byte)this.field_70180_af.func_187225_a(IS_LATCHED) == 2 ? (EntityLivingBase)this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(LATCHED_ID)).intValue()) : null;
        } else {
            if (this.hasCachedEntity) {
                this.findCachedEntity();
                this.cachedEntityUUID = null;
                this.hasCachedEntity = false;
            }
            if (this.field_70173_aa == 1) {
                byte isLatched = this.latched != null ? (byte)1 : (this.latchedEntity != null ? (byte)2 : 0);
                this.field_70180_af.func_187227_b(IS_LATCHED, (Object)isLatched);
                this.field_70180_af.func_187227_b(LATCHED_X, (Object)(this.latched != null ? this.latched.x : 0));
                this.field_70180_af.func_187227_b(LATCHED_Y, (Object)(this.latched != null ? this.latched.y : 0));
                this.field_70180_af.func_187227_b(LATCHED_Z, (Object)(this.latched != null ? this.latched.z : 0));
                this.field_70180_af.func_187227_b(LATCHED_ID, (Object)(this.latchedEntity != null ? this.latchedEntity.func_145782_y() : -1));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.latched != null && this.latched.exists(this.field_70170_p) && this.latched.isAirBlock((IBlockAccess)this.field_70170_p)) {
                this.latched = null;
                this.field_70180_af.func_187227_b(IS_LATCHED, (Object)0);
            }
            if (this.latchedEntity != null && (this.latchedEntity.func_110143_aJ() <= 0.0f || this.latchedEntity.field_70128_L || !this.field_70170_p.field_72996_f.contains(this.latchedEntity))) {
                this.latchedEntity = null;
                this.field_70180_af.func_187227_b(IS_LATCHED, (Object)0);
            }
        }
        if (!this.isLatched()) {
            this.field_70181_x = Math.min(this.field_70181_x * (double)1.02f, (double)0.2f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.98;
            this.field_70179_y *= 0.98;
            if (this.field_70122_E) {
                this.field_70159_w *= 0.7;
                this.field_70179_y *= 0.7;
            }
            if (this.field_70181_x == 0.0) {
                this.field_70181_x = 0.04;
            }
        } else if (this.latched != null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        } else if (this.latchedEntity != null && this.latchedEntity.func_110143_aJ() > 0.0f) {
            int floor = this.getFloor(this.latchedEntity);
            this.latchedEntity.field_70181_x = this.latchedEntity.field_70163_u - (double)(floor + 1) < -0.1 ? Math.max(0.04, this.latchedEntity.field_70181_x * 1.015) : (this.latchedEntity.field_70163_u - (double)(floor + 1) > 0.1 ? Math.min(-0.04, this.latchedEntity.field_70181_x * 1.015) : 0.0);
            this.func_70107_b(this.latchedEntity.field_70165_t, this.latchedEntity.field_70163_u + this.getAddedHeight(), this.latchedEntity.field_70161_v);
        }
    }

    public double getAddedHeight() {
        return (double)this.latchedEntity.field_70131_O + 0.8;
    }

    private int getFloor(EntityLivingBase entity) {
        BlockPos pos;
        BlockPos posi = pos = new BlockPos((Entity)entity);
        while (posi.func_177956_o() > 0) {
            if (posi.func_177956_o() < 256 && !this.field_70170_p.func_175623_d(posi)) {
                return posi.func_177956_o() + 1 + (entity instanceof EntityPlayer ? 1 : 0);
            }
            posi = posi.func_177977_b();
        }
        return -1;
    }

    private void findCachedEntity() {
        for (Object obj : this.field_70170_p.field_72996_f) {
            EntityLivingBase entity;
            if (!(obj instanceof EntityLivingBase) || !(entity = (EntityLivingBase)obj).func_110124_au().equals(this.cachedEntityUUID)) continue;
            this.latchedEntity = entity;
        }
    }

    private void pop() {
        this.func_184185_a(MekanismSounds.POP, 1.0f, 1.0f);
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                try {
                    this.doParticle();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticle() {
        Pos3D pos = new Pos3D(this.field_70165_t + ((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3), this.field_70163_u + ((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3), this.field_70161_v + ((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3));
        Particle fx = new ParticleRedstone.Factory().func_178902_a(0, this.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        fx.func_70538_b(this.color.getColor(0), this.color.getColor(1), this.color.getColor(2));
        Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
    }

    public boolean func_70104_M() {
        return this.latched == null;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull NBTTagCompound nbtTags) {
        this.color = EnumColor.values()[nbtTags.func_74762_e("color")];
        if (nbtTags.func_74764_b("latched")) {
            this.latched = Coord4D.read(nbtTags.func_74775_l("latched"));
        }
        if (nbtTags.func_74764_b("idMost")) {
            this.hasCachedEntity = true;
            this.cachedEntityUUID = new UUID(nbtTags.func_74763_f("idMost"), nbtTags.func_74763_f("idLeast"));
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("color", this.color.ordinal());
        if (this.latched != null) {
            nbtTags.func_74782_a("latched", (NBTBase)this.latched.write(new NBTTagCompound()));
        }
        if (this.latchedEntity != null) {
            nbtTags.func_74772_a("idMost", this.latchedEntity.func_110124_au().getMostSignificantBits());
            nbtTags.func_74772_a("idLeast", this.latchedEntity.func_110124_au().getLeastSignificantBits());
        }
    }

    public boolean func_85031_j(Entity entity) {
        this.pop();
        return true;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeDouble(this.field_70165_t);
        data.writeDouble(this.field_70163_u);
        data.writeDouble(this.field_70161_v);
        data.writeInt(this.color.ordinal());
        if (this.latched != null) {
            data.writeByte(1);
            this.latched.write(data);
        } else if (this.latchedEntity != null) {
            data.writeByte(2);
            data.writeInt(this.latchedEntity.func_145782_y());
        } else {
            data.writeByte(0);
        }
    }

    public void readSpawnData(ByteBuf data) {
        this.func_70107_b(data.readDouble(), data.readDouble(), data.readDouble());
        this.color = EnumColor.values()[data.readInt()];
        byte type = data.readByte();
        if (type == 1) {
            this.latched = Coord4D.read(data);
        } else if (type == 2) {
            this.latchedEntity = (EntityLivingBase)this.field_70170_p.func_73045_a(data.readInt());
        } else {
            this.latched = null;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.latchedEntity != null) {
            this.latchedEntity.field_70160_al = false;
        }
    }

    public boolean func_70112_a(double dist) {
        return dist <= 64.0;
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }

    public boolean func_70097_a(@Nonnull DamageSource dmgSource, float damage) {
        if (!this.func_180431_b(dmgSource)) {
            this.func_70018_K();
            if (dmgSource != DamageSource.field_76376_m && dmgSource != DamageSource.field_76369_e && dmgSource != DamageSource.field_76379_h) {
                this.pop();
                return true;
            }
        }
        return false;
    }

    public boolean isLatched() {
        if (!this.field_70170_p.field_72995_K) {
            return this.latched != null || this.latchedEntity != null;
        }
        return (Byte)this.field_70180_af.func_187225_a(IS_LATCHED) > 0;
    }

    public boolean isLatchedToEntity() {
        return (Byte)this.field_70180_af.func_187225_a(IS_LATCHED) == 2 && this.latchedEntity != null;
    }
}

