/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.StackSearcher;
import mekanism.common.content.transporter.TItemStackFilter;
import mekanism.common.content.transporter.TMaterialFilter;
import mekanism.common.content.transporter.TModIDFilter;
import mekanism.common.content.transporter.TOreDictFilter;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TransporterFilter
implements IFilter {
    public static final int MAX_LENGTH = 24;
    public static final List<Character> SPECIAL_CHARS = Arrays.asList(Character.valueOf('*'), Character.valueOf('-'), Character.valueOf(' '), Character.valueOf('|'), Character.valueOf('_'), Character.valueOf('\''));
    public EnumColor color;
    public boolean allowDefault;

    public static TransporterFilter readFromNBT(NBTTagCompound nbtTags) {
        TransporterFilter filter = TransporterFilter.getType(nbtTags.func_74762_e("type"));
        filter.read(nbtTags);
        return filter;
    }

    public static TransporterFilter readFromPacket(ByteBuf dataStream) {
        TransporterFilter filter = TransporterFilter.getType(dataStream.readInt());
        filter.read(dataStream);
        return filter;
    }

    @Nullable
    private static TransporterFilter getType(int type) {
        TransporterFilter filter = null;
        if (type == 0) {
            filter = new TItemStackFilter();
        } else if (type == 1) {
            filter = new TOreDictFilter();
        } else if (type == 2) {
            filter = new TMaterialFilter();
        } else if (type == 3) {
            filter = new TModIDFilter();
        }
        return filter;
    }

    public boolean canFilter(ItemStack itemStack, boolean strict) {
        return !itemStack.func_190926_b();
    }

    public abstract Finder getFinder();

    public InvStack getStackFromInventory(StackSearcher searcher, boolean singleItem) {
        return searcher.takeTopStack(this.getFinder(), singleItem ? 1 : 64);
    }

    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74757_a("allowDefault", this.allowDefault);
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
    }

    protected void read(NBTTagCompound nbtTags) {
        this.allowDefault = nbtTags.func_74767_n("allowDefault");
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
    }

    public void write(TileNetworkList data) {
        data.add(this.allowDefault);
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
    }

    protected void read(ByteBuf dataStream) {
        this.allowDefault = dataStream.readBoolean();
        int c = dataStream.readInt();
        this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + (this.color != null ? this.color.ordinal() : -1);
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object filter) {
        if (!(filter instanceof TransporterFilter)) return false;
        TransporterFilter filter1 = (TransporterFilter)filter;
        if (filter1.color != this.color) return false;
        return true;
    }
}

