/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;
import mekanism.api.TileNetworkList;
import mekanism.common.PacketHandler;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.TransporterFilter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TModIDFilter
extends TransporterFilter
implements IModIDFilter {
    private String modID;

    @Override
    public boolean canFilter(ItemStack itemStack, boolean strict) {
        return super.canFilter(itemStack, strict) && new Finder.ModIDFinder(this.modID).modifies(itemStack);
    }

    @Override
    public Finder getFinder() {
        return new Finder.ModIDFinder(this.modID);
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74768_a("type", 3);
        nbtTags.func_74778_a("modID", this.modID);
    }

    @Override
    protected void read(NBTTagCompound nbtTags) {
        super.read(nbtTags);
        this.modID = nbtTags.func_74779_i("modID");
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(3);
        super.write(data);
        data.add(this.modID);
    }

    @Override
    protected void read(ByteBuf dataStream) {
        super.read(dataStream);
        this.modID = PacketHandler.readString(dataStream);
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + super.hashCode();
        code = 31 * code + this.modID.hashCode();
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object filter) {
        if (!super.equals(filter)) return false;
        if (!(filter instanceof TModIDFilter)) return false;
        TModIDFilter tModIDFilter = (TModIDFilter)filter;
        if (!tModIDFilter.modID.equals(this.modID)) return false;
        return true;
    }

    public TModIDFilter clone() {
        TModIDFilter filter = new TModIDFilter();
        filter.allowDefault = this.allowDefault;
        filter.color = this.color;
        filter.modID = this.modID;
        return filter;
    }

    @Override
    public void setModID(String id) {
        this.modID = id;
    }

    @Override
    public String getModID() {
        return this.modID;
    }
}

