/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.StackSearcher;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemHandlerHelper;

public class TItemStackFilter
extends TransporterFilter
implements IItemStackFilter {
    public boolean sizeMode;
    public int min;
    public int max;
    private ItemStack itemType = ItemStack.field_190927_a;

    @Override
    public boolean canFilter(ItemStack itemStack, boolean strict) {
        return super.canFilter(itemStack, strict) && (!strict || !this.sizeMode || this.max != 0 && itemStack.func_190916_E() >= this.min) && ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)this.itemType, (ItemStack)itemStack);
    }

    @Override
    public InvStack getStackFromInventory(StackSearcher searcher, boolean singleItem) {
        if (this.sizeMode && !singleItem) {
            return searcher.takeDefinedItem(this.itemType, this.min, this.max);
        }
        return super.getStackFromInventory(searcher, singleItem);
    }

    @Override
    public Finder getFinder() {
        return new Finder.ItemStackFinder(this.itemType);
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74768_a("type", 0);
        nbtTags.func_74757_a("sizeMode", this.sizeMode);
        nbtTags.func_74768_a("min", this.min);
        nbtTags.func_74768_a("max", this.max);
        this.itemType.func_77955_b(nbtTags);
    }

    @Override
    protected void read(NBTTagCompound nbtTags) {
        super.read(nbtTags);
        this.sizeMode = nbtTags.func_74767_n("sizeMode");
        this.min = nbtTags.func_74762_e("min");
        this.max = nbtTags.func_74762_e("max");
        this.itemType = new ItemStack(nbtTags);
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(0);
        super.write(data);
        data.add(this.sizeMode);
        data.add(this.min);
        data.add(this.max);
        data.add(MekanismUtils.getID(this.itemType));
        data.add(this.itemType.func_190916_E());
        data.add(this.itemType.func_77952_i());
    }

    @Override
    protected void read(ByteBuf dataStream) {
        super.read(dataStream);
        this.sizeMode = dataStream.readBoolean();
        this.min = dataStream.readInt();
        this.max = dataStream.readInt();
        this.itemType = new ItemStack(Item.func_150899_d((int)dataStream.readInt()), dataStream.readInt(), dataStream.readInt());
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + super.hashCode();
        code = 31 * code + MekanismUtils.getID(this.itemType);
        code = 31 * code + this.itemType.func_190916_E();
        code = 31 * code + this.itemType.func_77952_i();
        code = 31 * code + (this.sizeMode ? 1 : 0);
        code = 31 * code + this.min;
        code = 31 * code + this.max;
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object filter) {
        if (!super.equals(filter)) return false;
        if (!(filter instanceof TItemStackFilter)) return false;
        TItemStackFilter stackFilter = (TItemStackFilter)filter;
        if (!stackFilter.itemType.func_77969_a(this.itemType)) return false;
        if (stackFilter.sizeMode != this.sizeMode) return false;
        if (stackFilter.min != this.min) return false;
        if (stackFilter.max != this.max) return false;
        return true;
    }

    public TItemStackFilter clone() {
        TItemStackFilter filter = new TItemStackFilter();
        filter.allowDefault = this.allowDefault;
        filter.color = this.color;
        filter.itemType = this.itemType.func_77946_l();
        filter.sizeMode = this.sizeMode;
        filter.min = this.min;
        filter.max = this.max;
        return filter;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@Nonnull ItemStack stack) {
        this.itemType = stack;
    }
}

