/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import net.minecraft.util.EnumFacing;

public class PathfinderCache {
    private static Map<PathData, List<Coord4D>> cachedPaths = new Object2ObjectOpenHashMap();

    public static void onChanged(Coord4D location) {
        PathfinderCache.reset();
    }

    public static void addCachedPath(PathData data, List<Coord4D> coords) {
        cachedPaths.put(data, coords);
    }

    public static List<Coord4D> getCache(Coord4D start, Coord4D end, Set<EnumFacing> sides) {
        List<Coord4D> ret = null;
        for (EnumFacing side : sides) {
            List<Coord4D> test = cachedPaths.get(new PathData(start, end, side));
            if (ret != null && (test == null || test.size() >= ret.size())) continue;
            ret = test;
        }
        return ret;
    }

    public static void reset() {
        cachedPaths.clear();
    }

    public static class PathData {
        private final Coord4D startTransporter;
        private final Coord4D end;
        private final EnumFacing endSide;
        private final int hash;

        public PathData(Coord4D s, Coord4D e, EnumFacing es) {
            this.startTransporter = s;
            this.end = e;
            this.endSide = es;
            int code = 1;
            code = 31 * code + this.startTransporter.hashCode();
            code = 31 * code + this.end.hashCode();
            this.hash = code = 31 * code + this.endSide.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PathData) {
                PathData data = (PathData)obj;
                return data.startTransporter.equals(this.startTransporter) && data.end.equals(this.end) && data.endSide.equals((Object)this.endSide);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

