/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Map;
import mekanism.common.Mekanism;
import mekanism.common.content.transporter.HashedItem;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public final class InvStack {
    private final TileEntity tileEntity;
    private final EnumFacing side;
    private Int2IntOpenHashMap itemMap;
    private HashedItem itemType;
    private int itemCount;

    public InvStack(TileEntity inv, EnumFacing facing) {
        this.tileEntity = inv;
        this.side = facing;
    }

    public InvStack(TileEntity inv, int slotID, ItemStack stack, EnumFacing facing) {
        this(inv, stack, InvStack.getMap(slotID, stack), facing);
    }

    public InvStack(TileEntity inv, ItemStack stack, Int2IntOpenHashMap idMap, EnumFacing facing) {
        this.tileEntity = inv;
        this.side = facing;
        this.itemMap = idMap;
        for (Map.Entry entry : idMap.entrySet()) {
            this.appendStack((Integer)entry.getKey(), StackUtils.size(stack, (Integer)entry.getValue()));
        }
    }

    public ItemStack getStack() {
        if (this.itemType == null || this.itemCount == 0) {
            return ItemStack.field_190927_a;
        }
        return StackUtils.size(this.itemType.getStack(), this.itemCount);
    }

    public void appendStack(int id, ItemStack stack) {
        if (this.itemType == null) {
            this.itemType = new HashedItem(stack);
        }
        this.itemMap.put(id, stack.func_190916_E());
        this.itemCount += stack.func_190916_E();
    }

    public void use(int amount) {
        if (!InventoryUtils.assertItemHandler("InvStack", this.tileEntity, this.side)) {
            return;
        }
        IItemHandler handler = InventoryUtils.getItemHandler(this.tileEntity, this.side);
        for (Map.Entry entry : this.itemMap.entrySet()) {
            int toUse = Math.min(amount, (Integer)entry.getValue());
            ItemStack ret = handler.extractItem(((Integer)entry.getKey()).intValue(), toUse, false);
            boolean stackable = InventoryUtils.areItemsStackable(this.itemType.getStack(), ret);
            if (!stackable || ret.func_190916_E() != toUse) {
                Mekanism.logger.warn("An inventory's returned content " + (!stackable ? "type" : "count") + " does not line up with InvStack's prediction.");
                Mekanism.logger.warn("InvStack item: " + this.itemType.getStack() + ", ret: " + ret);
                Mekanism.logger.warn("Tile: " + this.tileEntity + " " + this.tileEntity.func_174877_v());
            }
            if ((amount -= toUse) != 0) continue;
            return;
        }
    }

    public void use() {
        this.use(this.getStack().func_190916_E());
    }

    private static Int2IntOpenHashMap getMap(int slotID, ItemStack stack) {
        Int2IntOpenHashMap map = new Int2IntOpenHashMap();
        map.put(slotID, stack.func_190916_E());
        return map;
    }
}

