/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.block.BlockBasic;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.content.tank.TankCache;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import mekanism.common.tile.multiblock.TileEntityDynamicValve;
import mekanism.common.util.StackUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TankUpdateProtocol
extends UpdateProtocol<SynchronizedTankData> {
    public static final int FLUID_PER_TANK = MekanismConfig.current().general.dynamicTankFluidPerTank.val();

    public TankUpdateProtocol(TileEntityDynamicTank tileEntity) {
        super(tileEntity);
    }

    @Override
    protected boolean isValidFrame(int x, int y, int z) {
        IBlockState state = this.pointer.func_145831_w().func_180495_p(new BlockPos(x, y, z));
        return state.func_177230_c() == MekanismBlocks.BasicBlock && state.func_177229_b(((BlockBasic)state.func_177230_c()).getTypeProperty()) == BlockStateBasic.BasicBlockType.DYNAMIC_TANK;
    }

    protected TankCache getNewCache() {
        return new TankCache();
    }

    @Override
    protected SynchronizedTankData getNewStructure() {
        return new SynchronizedTankData();
    }

    @Override
    protected MultiblockManager<SynchronizedTankData> getManager() {
        return Mekanism.tankManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedTankData> cache, MultiblockCache<SynchronizedTankData> merge) {
        TankCache tankCache = (TankCache)cache;
        TankCache mergeCache = (TankCache)merge;
        if (tankCache.fluid == null) {
            tankCache.fluid = mergeCache.fluid;
        } else if (mergeCache.fluid != null && tankCache.fluid.isFluidEqual(mergeCache.fluid)) {
            tankCache.fluid.amount += mergeCache.fluid.amount;
        }
        if (tankCache.gas == null) {
            tankCache.gas = mergeCache.gas;
        } else if (mergeCache.gas != null && tankCache.gas.isGasEqual(mergeCache.gas)) {
            tankCache.gas.amount += mergeCache.gas.amount;
        }
        tankCache.editMode = mergeCache.editMode;
        List<ItemStack> rejects = StackUtils.getMergeRejects(tankCache.inventory, mergeCache.inventory);
        if (!rejects.isEmpty()) {
            rejectedItems.addAll(rejects);
        }
        StackUtils.merge(tankCache.inventory, mergeCache.inventory);
    }

    @Override
    protected void onFormed() {
        super.onFormed();
        if (((SynchronizedTankData)this.structureFound).fluidStored != null) {
            ((SynchronizedTankData)this.structureFound).fluidStored.amount = Math.min(((SynchronizedTankData)this.structureFound).fluidStored.amount, ((SynchronizedTankData)this.structureFound).volume * FLUID_PER_TANK);
        }
        if (((SynchronizedTankData)this.structureFound).gasstored != null) {
            ((SynchronizedTankData)this.structureFound).gasstored.amount = Math.min(((SynchronizedTankData)this.structureFound).gasstored.amount, ((SynchronizedTankData)this.structureFound).volume * FLUID_PER_TANK);
        }
    }

    @Override
    protected void onStructureCreated(SynchronizedTankData structure, int origX, int origY, int origZ, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        for (Coord4D obj : structure.locations) {
            if (!(obj.getTileEntity((IBlockAccess)this.pointer.func_145831_w()) instanceof TileEntityDynamicValve)) continue;
            SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
            data.location = obj;
            data.side = this.getSide(obj, origX + xmin, origX + xmax, origY + ymin, origY + ymax, origZ + zmin, origZ + zmax);
            structure.valves.add(data);
        }
    }
}

