/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import mekanism.api.gas.GasStack;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class TankCache
extends MultiblockCache<SynchronizedTankData> {
    public NonNullListSynchronized<ItemStack> inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
    public FluidStack fluid;
    public GasStack gas;
    public FluidContainerUtils.ContainerEditMode editMode = FluidContainerUtils.ContainerEditMode.BOTH;

    @Override
    public void apply(SynchronizedTankData data) {
        data.inventory = this.inventory;
        data.fluidStored = this.fluid;
        data.gasstored = this.gas;
        data.editMode = this.editMode;
    }

    @Override
    public void sync(SynchronizedTankData data) {
        this.inventory = data.inventory;
        this.fluid = data.fluidStored;
        this.gas = data.gasstored;
        this.editMode = data.editMode;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.editMode = FluidContainerUtils.ContainerEditMode.values()[nbtTags.func_74762_e("editMode")];
        NBTTagList tagList = nbtTags.func_150295_c("Items", 10);
        this.inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
        for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
            NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= 2) continue;
            this.inventory.set(slotID, new ItemStack(tagCompound));
        }
        if (nbtTags.func_74764_b("cachedFluid")) {
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cachedFluid"));
        }
        if (nbtTags.func_74764_b("cachedGas")) {
            this.gas = GasStack.readFromNBT(nbtTags.func_74775_l("cachedGas"));
        }
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("editMode", this.editMode.ordinal());
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < 2; ++slotCount) {
            if (this.inventory.get(slotCount).func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            this.inventory.get(slotCount).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTags.func_74782_a("Items", (NBTBase)tagList);
        if (this.fluid != null) {
            nbtTags.func_74782_a("cachedFluid", (NBTBase)this.fluid.writeToNBT(new NBTTagCompound()));
        }
        if (this.gas != null) {
            nbtTags.func_74782_a("cachedGas", (NBTBase)this.gas.write(new NBTTagCompound()));
        }
    }
}

