/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.gas.GasStack;
import mekanism.common.content.tank.TankUpdateProtocol;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class SynchronizedTankData
extends SynchronizedData<SynchronizedTankData> {
    public FluidStack fluidStored;
    public GasStack gasstored;
    public FluidStack prevFluid;
    public GasStack prevGas;
    public int prevFluidStage = 0;
    public int prevGasStage = 0;
    public FluidContainerUtils.ContainerEditMode editMode = FluidContainerUtils.ContainerEditMode.BOTH;
    public NonNullListSynchronized<ItemStack> inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
    public Set<ValveData> valves = new ObjectOpenHashSet();

    public boolean needsRenderUpdate() {
        if (this.fluidStored == null && this.prevFluid != null || this.fluidStored != null && this.prevFluid == null) {
            return true;
        }
        if (this.gasstored == null && this.prevGas != null || this.gasstored != null && this.prevGas == null) {
            return true;
        }
        if (this.fluidStored != null) {
            int totalStage = (this.volHeight - 2) * (TankUpdateProtocol.FLUID_PER_TANK / 100);
            int currentStage = (int)((float)this.fluidStored.amount / (float)(this.volume * TankUpdateProtocol.FLUID_PER_TANK) * (float)totalStage);
            boolean stageChanged = currentStage != this.prevFluidStage;
            this.prevFluidStage = currentStage;
            return this.fluidStored.getFluid() != this.prevFluid.getFluid() || stageChanged;
        }
        if (this.gasstored != null) {
            int totalStage = (this.volHeight - 2) * (TankUpdateProtocol.FLUID_PER_TANK / 100);
            int currentStage = (int)((float)this.gasstored.amount / (float)(this.volume * TankUpdateProtocol.FLUID_PER_TANK) * (float)totalStage);
            boolean stageChanged = currentStage != this.prevGasStage;
            this.prevGasStage = currentStage;
            return this.gasstored.getGas() != this.prevGas.getGas() || stageChanged;
        }
        return false;
    }

    @Override
    public NonNullListSynchronized<ItemStack> getInventory() {
        return this.inventory;
    }

    public static class ValveData {
        public EnumFacing side;
        public Coord4D location;
        public boolean prevActive;
        public int activeTicks;

        public void onTransfer() {
            this.activeTicks = 30;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.side.ordinal();
            code = 31 * code + this.location.hashCode();
            return code;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof ValveData)) return false;
            ValveData data = (ValveData)obj;
            if (data.side != this.side) return false;
            if (!data.location.equals(this.location)) return false;
            return true;
        }
    }
}

