/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.util.BlockInfo;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;

public class ThreadMinerSearch
extends Thread {
    private TileEntityDigitalMiner tileEntity;
    public State state = State.IDLE;
    private Map<Chunk3D, BitSet> oresToMine = new HashMap<Chunk3D, BitSet>();
    private Int2ObjectOpenHashMap<MinerFilter> replaceMap = new Int2ObjectOpenHashMap();
    private Map<BlockInfo, MinerFilter> acceptedItems = new HashMap<BlockInfo, MinerFilter>();
    private ChunkCache chunkCache;
    public int found = 0;

    public ThreadMinerSearch(TileEntityDigitalMiner tile) {
        this.tileEntity = tile;
    }

    public void setChunkCache(ChunkCache chunkCache) {
        this.chunkCache = chunkCache;
    }

    @Override
    public void run() {
        this.state = State.SEARCHING;
        if (!this.tileEntity.inverse && this.tileEntity.filters.isEmpty()) {
            this.state = State.FINISHED;
            return;
        }
        Coord4D coord = this.tileEntity.getStartingCoord();
        int diameter = this.tileEntity.getDiameter();
        int size = this.tileEntity.getTotalSize();
        BlockInfo info = new BlockInfo(null, 0);
        BlockPos minerPos = this.tileEntity.func_174877_v();
        for (int i = 0; i < size; ++i) {
            BlockPos testPos;
            if (this.tileEntity.func_145837_r()) {
                return;
            }
            int x = coord.x + i % diameter;
            int z = coord.z + i / diameter % diameter;
            int y = coord.y + i / diameter / diameter;
            if (minerPos.func_177958_n() == x && minerPos.func_177956_o() == y && minerPos.func_177952_p() == z || this.chunkCache.func_175625_s(testPos = new BlockPos(x, y, z)) instanceof TileEntityBoundingBlock) continue;
            IBlockState state = this.chunkCache.func_180495_p(testPos);
            info.block = state.func_177230_c();
            info.meta = state.func_177230_c().func_176201_c(state);
            if (info.block == null || info.block instanceof BlockLiquid || info.block instanceof IFluidBlock || info.block.isAir(state, (IBlockAccess)this.chunkCache, testPos)) continue;
            MinerFilter filterFound = null;
            if (this.acceptedItems.containsKey(info)) {
                filterFound = this.acceptedItems.get(info);
            } else {
                ItemStack stack = new ItemStack(info.block, 1, info.meta);
                if (this.tileEntity.isReplaceStack(stack)) continue;
                for (MinerFilter filter : this.tileEntity.filters) {
                    if (!filter.canFilter(stack)) continue;
                    filterFound = filter;
                    break;
                }
                this.acceptedItems.put(info, filterFound);
            }
            if (this.tileEntity.inverse != (filterFound == null)) continue;
            this.set(i, new Coord4D(x, y, z, this.tileEntity.func_145831_w().field_73011_w.getDimension()));
            this.replaceMap.put(i, (Object)filterFound);
            ++this.found;
        }
        this.state = State.FINISHED;
        this.tileEntity.oresToMine = this.oresToMine;
        this.tileEntity.replaceMap = this.replaceMap;
        this.chunkCache = null;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public void set(int i, Coord4D location) {
        Chunk3D chunk = new Chunk3D(location);
        this.oresToMine.computeIfAbsent(chunk, k -> new BitSet());
        this.oresToMine.get(chunk).set(i);
    }

    public void reset() {
        this.state = State.IDLE;
        this.chunkCache = null;
    }

    public static enum State {
        IDLE("gui.teleporter.notReady"),
        SEARCHING("gui.teleporter.Searching"),
        PAUSED("gui.teleporter.Paused"),
        FINISHED("gui.teleporter.ready");

        public String desc;

        private State(String s) {
            this.desc = s;
        }

        public String localize() {
            return LangUtils.localize(this.getTranslationKey());
        }

        public String getTranslationKey() {
            return this.desc;
        }
    }
}

