/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import io.netty.buffer.ByteBuf;
import mekanism.api.TileNetworkList;
import mekanism.common.PacketHandler;
import mekanism.common.content.filter.IOreDictFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.transporter.Finder;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MOreDictFilter
extends MinerFilter
implements IOreDictFilter {
    private String oreDictName;

    @Override
    public boolean canFilter(ItemStack itemStack) {
        if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        return new Finder.OreDictFinder(this.oreDictName).modifies(itemStack);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74768_a("type", 1);
        nbtTags.func_74778_a("oreDictName", this.oreDictName);
        return nbtTags;
    }

    @Override
    protected void read(NBTTagCompound nbtTags) {
        super.read(nbtTags);
        this.oreDictName = nbtTags.func_74779_i("oreDictName");
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(1);
        super.write(data);
        data.add(this.oreDictName);
    }

    @Override
    protected void read(ByteBuf dataStream) {
        super.read(dataStream);
        this.oreDictName = PacketHandler.readString(dataStream);
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.oreDictName.hashCode();
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object filter) {
        if (!super.equals(filter)) return false;
        if (!(filter instanceof MOreDictFilter)) return false;
        MOreDictFilter oreDictFilter = (MOreDictFilter)filter;
        if (!oreDictFilter.oreDictName.equals(this.oreDictName)) return false;
        return true;
    }

    public MOreDictFilter clone() {
        MOreDictFilter filter = new MOreDictFilter();
        filter.replaceStack = this.replaceStack;
        filter.requireStack = this.requireStack;
        filter.oreDictName = this.oreDictName;
        return filter;
    }

    @Override
    public void setOreDictName(String name) {
        this.oreDictName = name;
    }

    @Override
    public String getOreDictName() {
        return this.oreDictName;
    }
}

