/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.matrix;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.tile.multiblock.TileEntityInductionCell;
import mekanism.common.tile.multiblock.TileEntityInductionProvider;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SynchronizedMatrixData
extends SynchronizedData<SynchronizedMatrixData> {
    private NonNullListSynchronized<ItemStack> inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
    private Set<Coord4D> providers = new ObjectOpenHashSet();
    private Set<Coord4D> cells = new ObjectOpenHashSet();
    private double queuedOutput;
    private double queuedInput;
    private double lastOutput;
    private double lastInput;
    private double cachedTotal;
    private double transferCap;
    private double storageCap;
    private int clientProviders;
    private int clientCells;

    @Override
    public NonNullListSynchronized<ItemStack> getInventory() {
        return this.inventory;
    }

    public void setInventory(NonNullListSynchronized<ItemStack> inventory) {
        this.inventory = inventory;
    }

    public void addCell(Coord4D coord, TileEntityInductionCell cell) {
        this.cells.add(coord);
        this.storageCap += cell.tier.getMaxEnergy();
        this.cachedTotal += cell.getEnergy();
    }

    public void addProvider(Coord4D coord, TileEntityInductionProvider provider) {
        this.providers.add(coord);
        this.transferCap += provider.tier.getOutput();
    }

    public double getEnergyPostQueue() {
        return this.cachedTotal + this.queuedInput - this.queuedOutput;
    }

    public void tick(World world) {
        double lastChange = this.queuedInput - this.queuedOutput;
        if (lastChange < 0.0) {
            this.removeEnergy(world, -lastChange);
        } else if (lastChange > 0.0) {
            this.addEnergy(world, lastChange);
        }
        this.cachedTotal += lastChange;
        this.lastInput = this.queuedInput;
        this.queuedInput = 0.0;
        this.lastOutput = this.queuedOutput;
        this.queuedOutput = 0.0;
    }

    public double queueEnergyAddition(double energy, boolean simulate) {
        double availableEnergy;
        if (energy < 0.0) {
            return this.queueEnergyRemoval(-energy, simulate);
        }
        double remainingInput = this.getRemainingInput();
        if (energy > remainingInput) {
            energy = remainingInput;
        }
        if (energy > (availableEnergy = this.storageCap - this.getEnergyPostQueue())) {
            energy = availableEnergy;
        }
        if (!simulate) {
            this.queuedInput += energy;
        }
        return energy;
    }

    public double queueEnergyRemoval(double energy, boolean simulate) {
        double availableEnergy;
        if (energy < 0.0) {
            return this.queueEnergyAddition(-energy, simulate);
        }
        double remainingOutput = this.getRemainingOutput();
        if (energy > remainingOutput) {
            energy = remainingOutput;
        }
        if (energy > (availableEnergy = this.getEnergyPostQueue())) {
            energy = availableEnergy;
        }
        if (!simulate) {
            this.queuedOutput += energy;
        }
        return energy;
    }

    public void queueSetEnergy(double energy) {
        double difference;
        if (energy > this.storageCap) {
            energy = this.storageCap;
        }
        if ((difference = energy - this.getEnergyPostQueue()) != 0.0) {
            this.queueEnergyAddition(difference, false);
        }
    }

    private void addEnergy(World world, double energy) {
        for (Coord4D coord : this.cells) {
            double cellMax;
            TileEntityInductionCell cell;
            double cellEnergy;
            TileEntity tile = coord.getTileEntity((IBlockAccess)world);
            if (!(tile instanceof TileEntityInductionCell) || (cellEnergy = (cell = (TileEntityInductionCell)tile).getEnergy()) >= (cellMax = cell.getMaxEnergy())) continue;
            double cellSpace = cellMax - cellEnergy;
            if (cellSpace >= energy) {
                cell.setEnergy(cellEnergy + energy);
                MekanismUtils.saveChunk(cell);
                break;
            }
            cell.setEnergy(cellMax);
            energy -= cellSpace;
            MekanismUtils.saveChunk(cell);
        }
    }

    private void removeEnergy(World world, double energy) {
        for (Coord4D coord : this.cells) {
            TileEntityInductionCell cell;
            double cellEnergy;
            TileEntity tile = coord.getTileEntity((IBlockAccess)world);
            if (!(tile instanceof TileEntityInductionCell) || (cellEnergy = (cell = (TileEntityInductionCell)tile).getEnergy()) == 0.0) continue;
            if (cellEnergy >= energy) {
                cell.setEnergy(cellEnergy - energy);
                MekanismUtils.saveChunk(cell);
                break;
            }
            cell.setEnergy(0.0);
            energy -= cellEnergy;
            MekanismUtils.saveChunk(cell);
        }
    }

    public TileNetworkList addStructureData(TileNetworkList data) {
        data.add(this.cachedTotal);
        data.add(this.storageCap);
        data.add(this.transferCap);
        data.add(this.lastInput);
        data.add(this.lastOutput);
        data.add(this.volWidth);
        data.add(this.volHeight);
        data.add(this.volLength);
        data.add(this.cells.size());
        data.add(this.providers.size());
        return data;
    }

    public void readStructureData(ByteBuf dataStream) {
        this.cachedTotal = dataStream.readDouble();
        this.storageCap = dataStream.readDouble();
        this.transferCap = dataStream.readDouble();
        this.lastInput = dataStream.readDouble();
        this.lastOutput = dataStream.readDouble();
        this.volWidth = dataStream.readInt();
        this.volHeight = dataStream.readInt();
        this.volLength = dataStream.readInt();
        this.clientCells = dataStream.readInt();
        this.clientProviders = dataStream.readInt();
    }

    public double getStorageCap() {
        return this.storageCap;
    }

    public double getTransferCap() {
        return this.transferCap;
    }

    public double getEnergy() {
        return this.cachedTotal;
    }

    public double getLastInput() {
        return this.lastInput;
    }

    public double getLastOutput() {
        return this.lastOutput;
    }

    public double getRemainingInput() {
        return this.transferCap - this.queuedInput;
    }

    public double getRemainingOutput() {
        return this.transferCap - this.queuedOutput;
    }

    public int getCellCount() {
        return this.cells.isEmpty() ? this.clientCells : this.cells.size();
    }

    public int getProviderCount() {
        return this.providers.isEmpty() ? this.clientProviders : this.providers.size();
    }
}

