/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.entangloporter;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasTank;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tier.GasTankTier;
import mekanism.common.util.FluidTankSync;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidTank;

public class InventoryFrequency
extends Frequency {
    public static final String ENTANGLOPORTER = "Entangloporter";
    private static final Supplier<FluidTank> FLUID_TANK_SUPPLIER = () -> new FluidTankSync(MekanismConfig.current().general.quantumEntangloporterFluidBuffer.val());
    private static final Supplier<GasTank> GAS_TANK_SUPPLIER = () -> new GasTank(MekanismConfig.current().general.quantumEntangloporterGasBuffer.val());
    public double storedEnergy;
    public FluidTank storedFluid;
    public GasTank storedGas;
    public NonNullListSynchronized<ItemStack> inventory = NonNullListSynchronized.withSize(1, ItemStack.field_190927_a);
    public double temperature;

    public InventoryFrequency(String n, UUID uuid) {
        super(n, uuid);
        this.storedFluid = FLUID_TANK_SUPPLIER.get();
        this.storedGas = GAS_TANK_SUPPLIER.get();
    }

    public InventoryFrequency(NBTTagCompound nbtTags) {
        super(nbtTags);
    }

    public InventoryFrequency(ByteBuf dataStream) {
        super(dataStream);
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74780_a("storedEnergy", this.storedEnergy);
        if (this.storedFluid.getFluid() != null) {
            nbtTags.func_74782_a("storedFluid", (NBTBase)this.storedFluid.writeToNBT(new NBTTagCompound()));
        }
        if (this.storedGas.getGas() != null) {
            nbtTags.func_74782_a("storedGas", (NBTBase)this.storedGas.write(new NBTTagCompound()));
        }
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < 1; ++slotCount) {
            if (this.inventory.get(slotCount).func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            this.inventory.get(slotCount).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTags.func_74782_a("Items", (NBTBase)tagList);
        nbtTags.func_74780_a("temperature", this.temperature);
    }

    @Override
    protected void read(NBTTagCompound nbtTags) {
        super.read(nbtTags);
        this.storedFluid = FLUID_TANK_SUPPLIER.get();
        this.storedGas = GAS_TANK_SUPPLIER.get();
        this.storedEnergy = nbtTags.func_74769_h("storedEnergy");
        if (nbtTags.func_74764_b("storedFluid")) {
            this.storedFluid.readFromNBT(nbtTags.func_74775_l("storedFluid"));
        }
        if (nbtTags.func_74764_b("storedGas")) {
            this.storedGas.read(nbtTags.func_74775_l("storedGas"));
            this.storedGas.setMaxGas(MekanismConfig.current().general.quantumEntangloporterGasBuffer.val());
        }
        NBTTagList tagList = nbtTags.func_150295_c("Items", 10);
        this.inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
        for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
            NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID != 0) continue;
            this.inventory.set(slotID, new ItemStack(tagCompound));
        }
        this.temperature = nbtTags.func_74769_h("temperature");
    }

    @Override
    public void write(TileNetworkList data) {
        super.write(data);
        data.add(this.storedEnergy);
        TileUtils.addTankData(data, this.storedFluid);
        TileUtils.addTankData(data, this.storedGas);
        data.add(this.temperature);
    }

    @Override
    protected void read(ByteBuf dataStream) {
        super.read(dataStream);
        this.storedFluid = new FluidTankSync(FluidTankTier.ULTIMATE.getOutput());
        this.storedGas = new GasTank(GasTankTier.ULTIMATE.getOutput());
        this.storedEnergy = dataStream.readDouble();
        TileUtils.readTankData(dataStream, this.storedFluid);
        TileUtils.readTankData(dataStream, this.storedGas);
        this.temperature = dataStream.readDouble();
    }
}

