/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.gas.GasStack;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class SynchronizedBoilerData
extends SynchronizedData<SynchronizedBoilerData>
implements IHeatTransfer {
    public static Map<String, Boolean> clientHotMap = new Object2ObjectOpenHashMap();
    public static double CASING_INSULATION_COEFFICIENT = 1.0;
    public static double CASING_INVERSE_CONDUCTION_COEFFICIENT = 1.0;
    public static double BASE_BOIL_TEMP = 100.0 - (UnitDisplayUtils.TemperatureUnit.AMBIENT.zeroOffset - UnitDisplayUtils.TemperatureUnit.CELSIUS.zeroOffset);
    public FluidStack waterStored;
    public FluidStack prevWater;
    public FluidStack steamStored;
    public FluidStack prevSteam;
    public GasStack InputGas;
    public GasStack prevInputGas;
    public GasStack OutputGas;
    public GasStack prevOutputGas;
    public double lastEnvironmentLoss;
    public int lastBoilRate;
    public int lastMaxBoil;
    public boolean clientHot;
    public double temperature;
    public double heatToAbsorb;
    public double heatCapacity = 1000.0;
    public int superheatingElements;
    public int waterVolume;
    public int steamVolume;
    public NonNullListSynchronized<ItemStack> inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
    public Coord4D upperRenderLocation;
    public Set<SynchronizedTankData.ValveData> valves = new ObjectOpenHashSet();

    public static double getHeatEnthalpy() {
        return MekanismConfig.current().general.maxEnergyPerSteam.val() / MekanismConfig.current().general.energyPerHeat.val();
    }

    public double getHeatAvailable() {
        double heatAvailable = (this.temperature - BASE_BOIL_TEMP) * (double)this.locations.size();
        return Math.min(heatAvailable, (double)this.superheatingElements * MekanismConfig.current().general.superheatingHeatTransfer.val());
    }

    public boolean needsRenderUpdate() {
        if (this.waterStored == null && this.prevWater != null || this.waterStored != null && this.prevWater == null) {
            return true;
        }
        if (this.waterStored != null) {
            return this.waterStored.getFluid() != this.prevWater.getFluid() || this.waterStored.amount != this.prevWater.amount;
        }
        if (this.steamStored == null && this.prevSteam != null || this.steamStored != null && this.prevSteam == null) {
            return true;
        }
        if (this.steamStored != null) {
            return this.steamStored.getFluid() != this.prevSteam.getFluid() || this.steamStored.amount != this.prevSteam.amount;
        }
        if (this.InputGas == null && this.prevInputGas != null || this.InputGas != null && this.prevInputGas == null) {
            return true;
        }
        if (this.InputGas != null) {
            return this.InputGas.getGas() != this.prevInputGas.getGas() || this.InputGas.amount != this.prevInputGas.amount;
        }
        if (this.OutputGas == null && this.prevOutputGas != null || this.OutputGas != null && this.prevOutputGas == null) {
            return true;
        }
        if (this.OutputGas != null) {
            return this.OutputGas.getGas() != this.prevOutputGas.getGas() || this.OutputGas.amount != this.prevOutputGas.amount;
        }
        return false;
    }

    @Override
    public NonNullListSynchronized<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return CASING_INVERSE_CONDUCTION_COEFFICIENT * (double)this.locations.size();
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return CASING_INSULATION_COEFFICIENT * (double)this.locations.size();
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        double invConduction = 10000.0 + (CASING_INSULATION_COEFFICIENT + CASING_INVERSE_CONDUCTION_COEFFICIENT) * (double)this.locations.size();
        double heatToTransfer = this.temperature / invConduction;
        this.transferHeatTo(-heatToTransfer);
        return new double[]{0.0, heatToTransfer};
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.heatToAbsorb / (double)this.locations.size();
        this.heatToAbsorb = 0.0;
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return false;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        return null;
    }
}

