/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import mekanism.api.gas.GasStack;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.multiblock.MultiblockCache;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class BoilerCache
extends MultiblockCache<SynchronizedBoilerData> {
    public FluidStack water;
    public FluidStack steam;
    public GasStack input;
    public GasStack output;
    public double temperature;

    @Override
    public void apply(SynchronizedBoilerData data) {
        data.waterStored = this.water;
        data.steamStored = this.steam;
        data.InputGas = this.input;
        data.OutputGas = this.output;
        data.temperature = this.temperature;
    }

    @Override
    public void sync(SynchronizedBoilerData data) {
        this.water = data.waterStored;
        this.steam = data.steamStored;
        this.input = data.InputGas;
        this.output = data.OutputGas;
        this.temperature = data.temperature;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("cachedWater")) {
            this.water = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cachedWater"));
        }
        if (nbtTags.func_74764_b("cachedSteam")) {
            this.steam = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cachedSteam"));
        }
        if (nbtTags.func_74764_b("cachedInputGas")) {
            this.input = GasStack.readFromNBT(nbtTags.func_74775_l("cachedInputGas"));
        }
        if (nbtTags.func_74764_b("cachedOutputGas")) {
            this.output = GasStack.readFromNBT(nbtTags.func_74775_l("cachedOutputGas"));
        }
        this.temperature = nbtTags.func_74769_h("temperature");
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        if (this.water != null) {
            nbtTags.func_74782_a("cachedWater", (NBTBase)this.water.writeToNBT(new NBTTagCompound()));
        }
        if (this.steam != null) {
            nbtTags.func_74782_a("cachedSteam", (NBTBase)this.steam.writeToNBT(new NBTTagCompound()));
        }
        if (this.input != null) {
            nbtTags.func_74782_a("cachedInputGas", (NBTBase)this.input.write(new NBTTagCompound()));
        }
        if (this.output != null) {
            nbtTags.func_74782_a("cachedOutputGas", (NBTBase)this.output.write(new NBTTagCompound()));
        }
        nbtTags.func_74780_a("temperature", this.temperature);
    }
}

