/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import io.netty.buffer.ByteBuf;
import mekanism.common.config.BaseConfig;
import mekanism.common.config.TypeConfigManager;
import mekanism.common.config.options.BooleanOption;
import mekanism.common.config.options.DoubleOption;
import mekanism.common.config.options.IntOption;
import mekanism.common.config.options.IntSetOption;
import mekanism.generators.common.block.states.BlockStateGenerator;
import net.minecraftforge.common.config.Configuration;

public class GeneratorsConfig
extends BaseConfig {
    public final DoubleOption advancedSolarGeneration = new DoubleOption(this, "generation", "AdvancedSolarGeneration", 300.0, "Peak output for the Advanced Solar Generator. Note: It can go higher than this value in some extreme environments.");
    public final DoubleOption bioGeneration = new DoubleOption(this, "generation", "BioGeneration", 350.0, "Amount of energy in Joules the Bio Generator produces per tick.");
    public final DoubleOption heatGeneration = new DoubleOption(this, "generation", "HeatGeneration", 150.0, "Amount of energy in Joules the Heat Generator produces per tick. (heatGenerationLava * heatGenerationLava) + heatGenerationNether");
    public final DoubleOption heatGenerationLava = new DoubleOption(this, "generation", "HeatGenerationLava", 5.0, "Multiplier of effectiveness of Lava in the Heat Generator.");
    public final DoubleOption heatGenerationNether = new DoubleOption(this, "generation", "HeatGenerationNether", 100.0, "Add this amount of Joules to the energy produced by a heat generator if it is in the Nether.");
    public final DoubleOption solarGeneration = new DoubleOption(this, "generation", "SolarGeneration", 50.0, "Peak output for the Solar Generator. Note: It can go higher than this value in some extreme environments.");
    public final IntOption turbineBladesPerCoil = new IntOption(this, "generation", "TurbineBladesPerCoil", 4, "The number of blades on each turbine coil per blade applied.");
    public final DoubleOption turbineVentGasFlow = new DoubleOption(this, "generation", "TurbineVentGasFlow", 16000.0, "The rate at which steam is vented into the turbine.");
    public final DoubleOption turbineDisperserGasFlow = new DoubleOption(this, "generation", "TurbineDisperserGasFlow", 640.0, "The rate at which steam is dispersed into the turbine.");
    public final IntOption condenserRate = new IntOption(this, "generation", "TurbineCondenserFlowRate", 32000, "The rate at which steam is condensed in the turbine.");
    public final DoubleOption energyPerFusionFuel = new DoubleOption(this, "generation", "EnergyPerFusionFuel", 5000000.0, "Affects the Injection Rate, Max Temp, and Ignition Temp.");
    public final DoubleOption windGenerationMin = new DoubleOption(this, "generation", "WindGenerationMin", 60.0, "Minimum base generation value of the Wind Generator.");
    public final DoubleOption windGenerationMax = new DoubleOption(this, "generation", "WindGenerationMax", 480.0, "Maximum base generation value of the Wind Generator.");
    public final IntOption windGenerationMinY = new IntOption(this, "generation", "WindGenerationMinY", 24, "The minimum Y value that affects the Wind Generators Power generation.");
    public final IntOption windGenerationMaxY = new IntOption(this, "generation", "WindGenerationMaxY", 255, "The maximum Y value that affects the Wind Generators Power generation.");
    public final IntSetOption windGenerationDimBlacklist = (IntSetOption)new IntSetOption(this, "generation", "WindGenerationDimBlacklist", new int[0], "The list of dimension ids that the Wind Generator will not generate power in.").setRequiresWorldRestart(true);
    public final DoubleOption advancedSolarGeneratorStorage = new DoubleOption(this, "generation", "AdvancedSolarGeneratorStorage", 200000.0, "Energy capable of being stored");
    public final DoubleOption bioGeneratorStorage = new DoubleOption(this, "generation", "BioGeneratorStorage", 160000.0, "Energy capable of being stored");
    public final DoubleOption heatGeneratorStorage = new DoubleOption(this, "generation", "HeatGeneratorStorage", 160000.0, "Energy capable of being stored");
    public final DoubleOption solarGeneratorStorage = new DoubleOption(this, "generation", "SolarGeneratorStorage", 96000.0, "Energy capable of being stored");
    public final DoubleOption windGeneratorStorage = new DoubleOption(this, "generation", "WindGeneratorStorage", 96000.0, "Energy capable of being stored");
    public final DoubleOption turbineGeneratorStorage = new DoubleOption(this, "generation", "TurbineGeneratorStorage", 1.6E7, "How much energy per volume, default 16MJ");
    public final DoubleOption reactorGeneratorStorage = new DoubleOption(this, "generation", "ReactorGeneratorStorage", 1.0E9, "Energy capable of being stored");
    public final IntOption reactorGeneratorInjectionRate = new IntOption(this, "generation", "reactorGeneratorInjectionRate", 100, "The maximum injection rate of the fusion reactor needs to be set to a multiple of 2", 2, Integer.MAX_VALUE);
    public final BooleanOption windGeneratorItem = new BooleanOption(this, "generation", "WindGenerator", true, "Causes the item's wind turbine to rotate the blades");
    public final IntOption ItemHohlraumMaxGas = new IntOption(this, "generation", "ItemHohlraumMaxGas", 10, "How many gases can be added to Hohlraum", 1, Integer.MAX_VALUE);
    public final IntOption FusionReactorsDeuteriumTank = new IntOption((BaseConfig)this, "generation", "FusionReactorsDeuteriumTank", 1000);
    public final IntOption FusionReactorsTritiumTank = new IntOption((BaseConfig)this, "generation", "FusionReactorsTritiumTank", 1000);
    public final IntOption FusionReactorsFuelTank = new IntOption((BaseConfig)this, "generation", "FusionReactorsFuelTank", 1000);
    public final IntOption FusionReactorsWaterTank = new IntOption((BaseConfig)this, "generation", "FusionReactorsWaterTank", 100000);
    public final IntOption FusionReactorsSteamTank = new IntOption((BaseConfig)this, "generation", "FusionReactorsSteamTank", 10000000);
    public TypeConfigManager<BlockStateGenerator.GeneratorType> generatorsManager = new TypeConfigManager<BlockStateGenerator.GeneratorType>(this, "generators", BlockStateGenerator.GeneratorType.class, BlockStateGenerator.GeneratorType::getGeneratorsForConfig, BlockStateGenerator.GeneratorType::getBlockName);

    @Override
    public void load(Configuration config) {
        super.load(config);
        this.validate();
    }

    @Override
    public void read(ByteBuf config) {
        super.read(config);
        this.validate();
    }

    private void validate() {
        this.windGenerationMaxY.set(Math.max(this.windGenerationMinY.val() + 1, this.windGenerationMaxY.val()));
        int toUse = this.reactorGeneratorInjectionRate.val();
        toUse -= toUse % 2;
        this.reactorGeneratorInjectionRate.set(toUse);
    }
}

