/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.common.command.CommandChunk;
import mekanism.common.concurrent.TaskExecutor;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandGameRule;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandMek
extends CommandTreeBase {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,###.##");
    private final Map<UUID, Deque<BlockPos>> tpStack = new Object2ObjectOpenHashMap();

    public CommandMek() {
        this.addSubcommand((ICommand)new Cmd("debug", "cmd.mek.debug", this::toggleDebug));
        this.addSubcommand((ICommand)new Cmd("testrules", "cmd.mek.testrules", this::setupTestRules));
        this.addSubcommand((ICommand)new Cmd("tp", "cmd.mek.tp", this::teleportPush));
        this.addSubcommand((ICommand)new Cmd("tpop", "cmd.mek.tpop", this::teleportPop));
        this.addSubcommand((ICommand)new Cmd("performance_report", "cmd.mekceu.performance_report", CommandMek::performanceReport));
        this.addSubcommand((ICommand)new CommandChunk());
    }

    public static void register(FMLServerStartingEvent event) {
        CommandMek cmd = new CommandMek();
        event.registerServerCommand((ICommand)cmd);
        event.registerServerCommand((ICommand)new Cmd("mtp", "cmd.mek.tp", cmd::teleportPush));
        event.registerServerCommand((ICommand)new Cmd("mtpop", "cmd.mek.tpop", cmd::teleportPop));
    }

    @Nonnull
    public String func_71517_b() {
        return "mek";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "cmd.mek.usage";
    }

    public void toggleDebug(MinecraftServer server, ICommandSender sender, String[] args) {
        MekanismAPI.debug = !MekanismAPI.debug;
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.debug", (Object[])new Object[]{MekanismAPI.debug});
    }

    public void setupTestRules(MinecraftServer server, ICommandSender sender, String[] args) {
        GameRules rules = server.func_130014_f_().func_82736_K();
        rules.func_82764_b("doMobSpawning", "false");
        rules.func_82764_b("doDaylightCycle", "false");
        rules.func_82764_b("doWeatherCycle", "false");
        server.func_130014_f_().func_72877_b(2000L);
        CommandGameRule.func_184898_a((GameRules)rules, (String)"", (MinecraftServer)server);
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.testrules", (Object[])new Object[0]);
    }

    public void teleportPush(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 3) {
            CommandMek.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.tp.missing.args", (Object[])new Object[0]);
            return;
        }
        CommandBase.CoordinateArg xArg = CommandMek.func_175770_a((double)10.0, (String)args[0], (boolean)true);
        CommandBase.CoordinateArg yArg = CommandMek.func_175770_a((double)10.0, (String)args[1], (boolean)true);
        CommandBase.CoordinateArg zArg = CommandMek.func_175770_a((double)10.0, (String)args[2], (boolean)true);
        UUID player = sender.func_174793_f().func_110124_au();
        Deque playerLocations = this.tpStack.getOrDefault(player, new ArrayDeque());
        playerLocations.push(sender.func_180425_c());
        this.tpStack.put(player, playerLocations);
        CommandMek.teleport(sender.func_174793_f(), xArg.func_179628_a(), yArg.func_179628_a(), zArg.func_179628_a());
        CommandMek.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.tp", (Object[])new Object[]{args[0], args[1], args[2]});
    }

    public void teleportPop(MinecraftServer server, ICommandSender sender, String[] args) {
        UUID player = sender.func_174793_f().func_110124_au();
        Deque playerLocations = this.tpStack.getOrDefault(player, new ArrayDeque());
        if (!playerLocations.isEmpty()) {
            BlockPos lastPos = (BlockPos)playerLocations.pop();
            this.tpStack.put(player, playerLocations);
            CommandMek.teleport(sender.func_174793_f(), lastPos.func_177958_n(), lastPos.func_177956_o(), lastPos.func_177952_p());
            CommandMek.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.tpop", (Object[])new Object[]{lastPos.func_177958_n(), lastPos.func_177956_o(), lastPos.func_177952_p(), playerLocations.size()});
        } else {
            CommandMek.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.tpop.empty.stack", (Object[])new Object[0]);
        }
    }

    private static void teleport(Entity player, double x, double y, double z) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            mp.field_71135_a.func_147364_a(x, y, z, mp.field_70177_z, mp.field_70125_A);
        } else {
            EntityPlayerSP sp = (EntityPlayerSP)player;
            sp.func_70012_b(x, y, z, sp.field_70177_z, sp.field_70125_A);
        }
    }

    public static void performanceReport(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, String[] args) {
        String langKey = "cmd.mekceu.performance_report";
        if (args.length > 0 && args[0].equals("reset")) {
            TaskExecutor.executedCount = 0L;
            TaskExecutor.totalExecuted = 0L;
            TaskExecutor.totalUsedTime = 0L;
            TaskExecutor.taskUsedTime = 0L;
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(langKey + ".reset", new Object[0]));
            return;
        }
        long executedAvgPerExecution = TaskExecutor.executedCount == 0L ? 0L : TaskExecutor.totalExecuted / TaskExecutor.executedCount;
        double usedTimeAvgPerExecution = TaskExecutor.executedCount == 0L ? 0.0 : (double)(TaskExecutor.totalUsedTime / TaskExecutor.executedCount) / 1000.0;
        double taskUsedTimeAvg = TaskExecutor.totalExecuted == 0L ? 0.0 : (double)(TaskExecutor.taskUsedTime / TaskExecutor.executedCount) / 1000.0;
        long usedTimeAvg = TaskExecutor.totalExecuted == 0L ? 0L : TaskExecutor.taskUsedTime / TaskExecutor.totalExecuted;
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(langKey + ".title", new Object[]{TextFormatting.GREEN + CommandMek.formatDecimal(TaskExecutor.executedCount) + TextFormatting.RESET}));
        sender.func_145747_a((ITextComponent)new TextComponentString(""));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(langKey + ".total_executed", new Object[]{TextFormatting.BLUE + CommandMek.formatDecimal(TaskExecutor.totalExecuted) + TextFormatting.RESET}));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(langKey + ".tasks_avg_per_execution", new Object[]{TextFormatting.BLUE + String.valueOf(executedAvgPerExecution) + TextFormatting.RESET}));
        sender.func_145747_a((ITextComponent)new TextComponentString(""));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(langKey + ".total_used_time", new Object[]{TextFormatting.BLUE + String.valueOf(TaskExecutor.totalUsedTime / 1000L) + TextFormatting.RESET}));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(langKey + ".used_time_avg_per_execution", new Object[]{TextFormatting.YELLOW + String.format("%.2f", usedTimeAvgPerExecution) + TextFormatting.RESET}));
        sender.func_145747_a((ITextComponent)new TextComponentString(""));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(langKey + ".task_used_time", new Object[]{TextFormatting.BLUE + CommandMek.formatDecimal((double)TaskExecutor.taskUsedTime / 1000.0) + TextFormatting.RESET}));
        sender.func_145747_a((ITextComponent)new TextComponentString(""));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(langKey + ".task_used_time_avg", new Object[]{TextFormatting.YELLOW + String.format("%.2f", taskUsedTimeAvg) + TextFormatting.RESET}));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(langKey + ".used_time_avg", new Object[]{TextFormatting.BLUE + String.valueOf(usedTimeAvg) + TextFormatting.RESET}));
    }

    public static String formatDecimal(double value) {
        return DECIMAL_FORMAT.format(value);
    }

    public static class Cmd
    extends CommandBase {
        private final String name;
        private final String usage;
        private final CmdExecute ex;

        Cmd(String name, String usage, CmdExecute ex) {
            this.name = name;
            this.usage = usage;
            this.ex = ex;
        }

        @Nonnull
        public String func_71517_b() {
            return this.name;
        }

        @Nonnull
        public String func_71518_a(@Nonnull ICommandSender sender) {
            return this.usage + ".usage";
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
            this.ex.execute(server, sender, args);
        }
    }

    static interface CmdExecute {
        public void execute(MinecraftServer var1, ICommandSender var2, String[] var3) throws CommandException;
    }
}

