/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;

public class DefaultStorageHelper {

    public static class NullStorage<T>
    implements Capability.IStorage<T> {
        public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
            return new NBTTagCompound();
        }

        public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
        }
    }

    public static class DefaultStorage<T>
    implements Capability.IStorage<T> {
        public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
            if (instance instanceof INBTSerializable) {
                INBTSerializable serializable = (INBTSerializable)instance;
                return serializable.serializeNBT();
            }
            return new NBTTagCompound();
        }

        public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
            INBTSerializable serializable;
            Class<?> nbtClass;
            if (instance instanceof INBTSerializable && (nbtClass = (serializable = (INBTSerializable)instance).serializeNBT().getClass()).isInstance(nbt)) {
                ((INBTSerializable)instance).deserializeNBT((NBTBase)nbtClass.cast(nbt));
            }
        }
    }
}

