/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.common.MekanismBlocks;
import mekanism.common.base.IBlockType;
import mekanism.common.base.IFactory;
import mekanism.common.block.BlockMachine;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.block.states.BlockStateUtils;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityFuelwoodHeater;
import mekanism.common.tile.TileEntityHybridStorage;
import mekanism.common.tile.TileEntityIndustrialAlarm;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityModificationStation;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.TileEntityRadioactiveWasteBarrel;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.tile.TileEntitySuperchargedCoil;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.factory.TileEntityAdvancedFactory;
import mekanism.common.tile.factory.TileEntityCreativeFactory;
import mekanism.common.tile.factory.TileEntityEliteFactory;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.factory.TileEntityUltimateFactory;
import mekanism.common.tile.laser.TileEntityLaser;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.laser.TileEntityLaserTractorBeam;
import mekanism.common.tile.machine.TileEntityAlloy;
import mekanism.common.tile.machine.TileEntityAmbientAccumulator;
import mekanism.common.tile.machine.TileEntityAmbientAccumulatorEnergy;
import mekanism.common.tile.machine.TileEntityAntiprotonicNucleosynthesizer;
import mekanism.common.tile.machine.TileEntityBrushed;
import mekanism.common.tile.machine.TileEntityCellExtractor;
import mekanism.common.tile.machine.TileEntityCellSeparator;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import mekanism.common.tile.machine.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.machine.TileEntityChemicalInfuser;
import mekanism.common.tile.machine.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.machine.TileEntityChemicalOxidizer;
import mekanism.common.tile.machine.TileEntityChemicalWasher;
import mekanism.common.tile.machine.TileEntityCombiner;
import mekanism.common.tile.machine.TileEntityCrusher;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityElectricPump;
import mekanism.common.tile.machine.TileEntityElectrolyticSeparator;
import mekanism.common.tile.machine.TileEntityEnergizedSmelter;
import mekanism.common.tile.machine.TileEntityEnrichmentChamber;
import mekanism.common.tile.machine.TileEntityFluidicPlenisher;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.machine.TileEntityIsotopicCentrifuge;
import mekanism.common.tile.machine.TileEntityMetallurgicInfuser;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.tile.machine.TileEntityOrganicFarm;
import mekanism.common.tile.machine.TileEntityOsmiumCompressor;
import mekanism.common.tile.machine.TileEntityPRC;
import mekanism.common.tile.machine.TileEntityPrecisionSawmill;
import mekanism.common.tile.machine.TileEntityPurificationChamber;
import mekanism.common.tile.machine.TileEntityRecycler;
import mekanism.common.tile.machine.TileEntityRolling;
import mekanism.common.tile.machine.TileEntityRotaryCondensentrator;
import mekanism.common.tile.machine.TileEntitySeismicVibrator;
import mekanism.common.tile.machine.TileEntitySolarNeutronActivator;
import mekanism.common.tile.machine.TileEntityStamping;
import mekanism.common.tile.machine.TileEntityTurning;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStateMachine
extends ExtendedBlockState {
    public static final PropertyBool activeProperty = PropertyBool.func_177716_a((String)"active");
    public static final PropertyEnum<BaseTier> tierProperty = PropertyEnum.func_177709_a((String)"tier", BaseTier.class);
    public static final PropertyEnum<IFactory.RecipeType> recipeProperty = PropertyEnum.func_177709_a((String)"recipe", IFactory.RecipeType.class);

    public BlockStateMachine(BlockMachine block, PropertyEnum<?> typeProperty) {
        super((Block)block, new IProperty[]{BlockStateFacing.facingProperty, typeProperty, activeProperty, tierProperty, recipeProperty}, new IUnlistedProperty[0]);
    }

    public static class MachineBlockStateMapper
    extends StateMapperBase {
        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            BlockMachine block = (BlockMachine)state.func_177230_c();
            MachineType type = (MachineType)((Object)state.func_177229_b(block.getTypeProperty()));
            StringBuilder builder = new StringBuilder();
            String nameOverride = null;
            if (type.hasActiveTexture()) {
                builder.append(activeProperty.func_177701_a());
                builder.append("=");
                builder.append(state.func_177229_b((IProperty)activeProperty));
            }
            if (type.hasRotations()) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockStateFacing.facingProperty);
                if (!type.canRotateTo(facing)) {
                    facing = EnumFacing.NORTH;
                }
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(BlockStateFacing.facingProperty.func_177701_a());
                builder.append("=");
                builder.append(facing.func_176610_l());
            }
            if (type == MachineType.BASIC_FACTORY || type == MachineType.ADVANCED_FACTORY || type == MachineType.ELITE_FACTORY || type == MachineType.ULTIMATE_FACTORY || type == MachineType.CREATIVE_FACTORY) {
                IFactory.RecipeType recipe = (IFactory.RecipeType)((Object)state.func_177229_b(recipeProperty));
                nameOverride = type.func_176610_l() + "_" + recipe.func_176610_l();
            }
            if (builder.length() == 0) {
                builder.append("normal");
            }
            ResourceLocation baseLocation = new ResourceLocation("mekanism", nameOverride != null ? nameOverride : type.func_176610_l());
            return new ModelResourceLocation(baseLocation, builder.toString());
        }
    }

    public static enum MachineType implements IStringSerializable,
    IBlockType
    {
        ENRICHMENT_CHAMBER(MachineBlock.MACHINE_BLOCK_1, 0, "EnrichmentChamber", 3, TileEntityEnrichmentChamber::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        OSMIUM_COMPRESSOR(MachineBlock.MACHINE_BLOCK_1, 1, "OsmiumCompressor", 4, TileEntityOsmiumCompressor::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        COMBINER(MachineBlock.MACHINE_BLOCK_1, 2, "Combiner", 5, TileEntityCombiner::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        CRUSHER(MachineBlock.MACHINE_BLOCK_1, 3, "Crusher", 6, TileEntityCrusher::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        DIGITAL_MINER(MachineBlock.MACHINE_BLOCK_1, 4, "DigitalMiner", 2, TileEntityDigitalMiner::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        BASIC_FACTORY(MachineBlock.MACHINE_BLOCK_1, 5, "Factory", 11, TileEntityFactory::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, FactoryTier.BASIC, false, false),
        ADVANCED_FACTORY(MachineBlock.MACHINE_BLOCK_1, 6, "Factory", 11, TileEntityAdvancedFactory::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, FactoryTier.ADVANCED, false, false),
        ELITE_FACTORY(MachineBlock.MACHINE_BLOCK_1, 7, "Factory", 11, TileEntityEliteFactory::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, FactoryTier.ELITE, false, false),
        METALLURGIC_INFUSER(MachineBlock.MACHINE_BLOCK_1, 8, "MetallurgicInfuser", 12, TileEntityMetallurgicInfuser::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, false, false),
        PURIFICATION_CHAMBER(MachineBlock.MACHINE_BLOCK_1, 9, "PurificationChamber", 15, TileEntityPurificationChamber::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        ENERGIZED_SMELTER(MachineBlock.MACHINE_BLOCK_1, 10, "EnergizedSmelter", 16, TileEntityEnergizedSmelter::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        TELEPORTER(MachineBlock.MACHINE_BLOCK_1, 11, "Teleporter", 13, TileEntityTeleporter::new, true, false, false, BlockStateUtils.NO_ROTATION, false, true, true),
        ELECTRIC_PUMP(MachineBlock.MACHINE_BLOCK_1, 12, "ElectricPump", 17, TileEntityElectricPump::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, false, false),
        PERSONAL_CHEST(MachineBlock.MACHINE_BLOCK_1, 13, "PersonalChest", 19, TileEntityPersonalChest::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, false, false),
        CHARGEPAD(MachineBlock.MACHINE_BLOCK_1, 14, "Chargepad", -1, TileEntityChargepad::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, false, false),
        LOGISTICAL_SORTER(MachineBlock.MACHINE_BLOCK_1, 15, "LogisticalSorter", 59, TileEntityLogisticalSorter::new, false, true, false, BlockStateUtils.ALL_FACINGS, true, false, false),
        ROTARY_CONDENSENTRATOR(MachineBlock.MACHINE_BLOCK_2, 0, "RotaryCondensentrator", 7, TileEntityRotaryCondensentrator::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, false, false),
        CHEMICAL_OXIDIZER(MachineBlock.MACHINE_BLOCK_2, 1, "ChemicalOxidizer", 29, TileEntityChemicalOxidizer::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        CHEMICAL_INFUSER(MachineBlock.MACHINE_BLOCK_2, 2, "ChemicalInfuser", 30, TileEntityChemicalInfuser::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        CHEMICAL_INJECTION_CHAMBER(MachineBlock.MACHINE_BLOCK_2, 3, "ChemicalInjectionChamber", 31, TileEntityChemicalInjectionChamber::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        ELECTROLYTIC_SEPARATOR(MachineBlock.MACHINE_BLOCK_2, 4, "ElectrolyticSeparator", 32, TileEntityElectrolyticSeparator::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        PRECISION_SAWMILL(MachineBlock.MACHINE_BLOCK_2, 5, "PrecisionSawmill", 34, TileEntityPrecisionSawmill::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        CHEMICAL_DISSOLUTION_CHAMBER(MachineBlock.MACHINE_BLOCK_2, 6, "ChemicalDissolutionChamber", 35, TileEntityChemicalDissolutionChamber::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        CHEMICAL_WASHER(MachineBlock.MACHINE_BLOCK_2, 7, "ChemicalWasher", 36, TileEntityChemicalWasher::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        CHEMICAL_CRYSTALLIZER(MachineBlock.MACHINE_BLOCK_2, 8, "ChemicalCrystallizer", 37, TileEntityChemicalCrystallizer::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        SEISMIC_VIBRATOR(MachineBlock.MACHINE_BLOCK_2, 9, "SeismicVibrator", 39, TileEntitySeismicVibrator::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        PRESSURIZED_REACTION_CHAMBER(MachineBlock.MACHINE_BLOCK_2, 10, "PressurizedReactionChamber", 40, TileEntityPRC::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        FLUID_TANK(MachineBlock.MACHINE_BLOCK_2, 11, "FluidTank", 41, TileEntityFluidTank::new, false, true, false, BlockStateUtils.NO_ROTATION, true, false, false),
        FLUIDIC_PLENISHER(MachineBlock.MACHINE_BLOCK_2, 12, "FluidicPlenisher", 42, TileEntityFluidicPlenisher::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        LASER(MachineBlock.MACHINE_BLOCK_2, 13, "Laser", -1, TileEntityLaser::new, true, true, false, BlockStateUtils.ALL_FACINGS, false, false, false),
        LASER_AMPLIFIER(MachineBlock.MACHINE_BLOCK_2, 14, "LaserAmplifier", 44, TileEntityLaserAmplifier::new, false, true, false, BlockStateUtils.ALL_FACINGS, true, false, false),
        LASER_TRACTOR_BEAM(MachineBlock.MACHINE_BLOCK_2, 15, "LaserTractorBeam", 45, TileEntityLaserTractorBeam::new, false, true, false, BlockStateUtils.ALL_FACINGS, true, false, false),
        QUANTUM_ENTANGLOPORTER(MachineBlock.MACHINE_BLOCK_3, 0, "QuantumEntangloporter", 46, TileEntityQuantumEntangloporter::new, true, false, false, BlockStateUtils.ALL_FACINGS, false, false, false),
        SOLAR_NEUTRON_ACTIVATOR(MachineBlock.MACHINE_BLOCK_3, 1, "SolarNeutronActivator", 47, TileEntitySolarNeutronActivator::new, false, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        AMBIENT_ACCUMULATOR(MachineBlock.MACHINE_BLOCK_3, 2, "AmbientAccumulator", 48, TileEntityAmbientAccumulator::new, false, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        OREDICTIONIFICATOR(MachineBlock.MACHINE_BLOCK_3, 3, "Oredictionificator", 52, TileEntityOredictionificator::new, false, false, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        RESISTIVE_HEATER(MachineBlock.MACHINE_BLOCK_3, 4, "ResistiveHeater", 53, TileEntityResistiveHeater::new, true, false, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        FORMULAIC_ASSEMBLICATOR(MachineBlock.MACHINE_BLOCK_3, 5, "FormulaicAssemblicator", 56, TileEntityFormulaicAssemblicator::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        FUELWOOD_HEATER(MachineBlock.MACHINE_BLOCK_3, 6, "FuelwoodHeater", 58, TileEntityFuelwoodHeater::new, false, false, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        ULTIMATE_FACTORY(MachineBlock.MACHINE_BLOCK_3, 7, "Factory", 11, TileEntityUltimateFactory::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, FactoryTier.ULTIMATE, false, false),
        CREATIVE_FACTORY(MachineBlock.MACHINE_BLOCK_3, 8, "Factory", 11, TileEntityCreativeFactory::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, FactoryTier.CREATIVE, false, false),
        ISOTOPIC_CENTRIFUGE(MachineBlock.MACHINE_BLOCK_3, 9, "IsotopicCentrifuge", 60, TileEntityIsotopicCentrifuge::new, true, true, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, false, false),
        NUTRITIONAL_LIQUIFIER(MachineBlock.MACHINE_BLOCK_3, 10, "NutritionalLiquifier", 61, TileEntityNutritionalLiquifier::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, false, false),
        SUPERCHARGED_COIL(MachineBlock.MACHINE_BLOCK_3, 11, "SuperchargedCoil", -1, TileEntitySuperchargedCoil::new, false, true, false, BlockStateUtils.ALL_FACINGS, false, false, false),
        ORGANIC_FARM(MachineBlock.MACHINE_BLOCK_3, 12, "OrganicFarm", 62, TileEntityOrganicFarm::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        ANTIPROTONIC_NUCLEOSYNTHESIZER(MachineBlock.MACHINE_BLOCK_3, 13, "antiprotonicnucleosynthesizer", 63, TileEntityAntiprotonicNucleosynthesizer::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        AMBIENT_ACCUMULATOR_ENERGY(MachineBlock.MACHINE_BLOCK_3, 14, "AmbientAccumulatorEnergy", 73, TileEntityAmbientAccumulatorEnergy::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        STAMPING(MachineBlock.MACHINE_BLOCK_4, 0, "Stamping", 64, TileEntityStamping::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        ROLLING(MachineBlock.MACHINE_BLOCK_4, 1, "Rolling", 65, TileEntityRolling::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        BRUSHED(MachineBlock.MACHINE_BLOCK_4, 2, "Brushed", 66, TileEntityBrushed::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        TURNING(MachineBlock.MACHINE_BLOCK_4, 3, "Turning", 67, TileEntityTurning::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        ALLOY(MachineBlock.MACHINE_BLOCK_4, 4, "Alloy", 68, TileEntityAlloy::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        CELL_EXTRACTOR(MachineBlock.MACHINE_BLOCK_4, 6, "CellExtractor", 70, TileEntityCellExtractor::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        CELL_SEPARATOR(MachineBlock.MACHINE_BLOCK_4, 7, "CellSeparator", 71, TileEntityCellSeparator::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        RECYCLER(MachineBlock.MACHINE_BLOCK_4, 8, "Recycler", 72, TileEntityRecycler::new, true, false, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, true),
        INDUSTRIAL_ALARM(MachineBlock.MACHINE_BLOCK_4, 9, "IndustrialAlarm", -1, TileEntityIndustrialAlarm::new, false, true, false, BlockStateUtils.ALL_FACINGS, false, false, false),
        HYBRID_STORAGE(MachineBlock.MACHINE_BLOCK_4, 10, "Hybrid_Storage", 74, TileEntityHybridStorage::new, true, false, false, BlockStateUtils.ALL_FACINGS, false, true, true),
        MODIFICATION_STATION(MachineBlock.MACHINE_BLOCK_4, 11, "Modification_Station", 75, TileEntityModificationStation::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, false, false),
        RADIOACTIVE_WASTE_BARREL(MachineBlock.MACHINE_BLOCK_4, 12, "radioactive_waste_barrel", -1, TileEntityRadioactiveWasteBarrel::new, false, false, false, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, false, false);

        private static final Map<MachineBlock, Int2ReferenceMap<MachineType>> VALID_METAS;
        public MachineBlock typeBlock;
        public int meta;
        public String blockName;
        public int guiId;
        public Supplier<TileEntity> tileEntitySupplier;
        public boolean isElectric;
        public boolean hasModel;
        public boolean supportsUpgrades;
        public Predicate<EnumFacing> facingPredicate;
        public boolean activable;
        public FactoryTier factoryTier;
        public boolean isFullBlock;
        public boolean isOpaqueCube;
        private static final List<MachineType> VALID_MACHINES;

        private MachineType(MachineBlock block, int m, String name, int gui, Supplier<TileEntity> tileClass, boolean electric, boolean model, boolean upgrades, Predicate<EnumFacing> predicate, boolean hasActiveTexture, boolean fullBlock, boolean opaque) {
            this(block, m, name, gui, tileClass, electric, model, upgrades, predicate, hasActiveTexture, null, fullBlock, opaque);
        }

        private MachineType(MachineBlock block, int m, String name, int gui, Supplier<TileEntity> tileClass, boolean electric, boolean model, boolean upgrades, Predicate<EnumFacing> predicate, boolean hasActiveTexture, FactoryTier factoryTier, boolean fullBlock, boolean opaque) {
            this.typeBlock = block;
            this.meta = m;
            this.blockName = name;
            this.guiId = gui;
            this.tileEntitySupplier = tileClass;
            this.isElectric = electric;
            this.hasModel = model;
            this.supportsUpgrades = upgrades;
            this.facingPredicate = predicate;
            this.activable = hasActiveTexture;
            this.factoryTier = factoryTier;
            this.isFullBlock = fullBlock;
            this.isOpaqueCube = opaque;
        }

        private void registerType() {
            VALID_METAS.computeIfAbsent(this.typeBlock, k -> new Int2ReferenceOpenHashMap()).put(this.meta, (Object)this);
        }

        public static List<MachineType> getValidMachines() {
            return VALID_MACHINES;
        }

        public static MachineType get(IBlockState state) {
            Block block = state.func_177230_c();
            if (block instanceof BlockMachine) {
                BlockMachine machine = (BlockMachine)block;
                return (MachineType)((Object)state.func_177229_b(machine.getTypeProperty()));
            }
            return null;
        }

        public static MachineType get(Block block, int meta) {
            if (block instanceof BlockMachine) {
                BlockMachine machine = (BlockMachine)block;
                return MachineType.get(machine.getMachineBlock(), meta);
            }
            return null;
        }

        public static MachineType get(MachineBlock block, int meta) {
            Int2ReferenceMap<MachineType> meta2Type = VALID_METAS.get((Object)block);
            if (meta2Type == null) {
                return null;
            }
            return (MachineType)meta2Type.get(meta);
        }

        public static MachineType get(ItemStack stack) {
            return MachineType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
        }

        @Override
        public String getBlockName() {
            return this.blockName;
        }

        @Override
        public boolean isEnabled() {
            return MekanismConfig.current().general.machinesManager.isEnabled(this);
        }

        public boolean isValidMachine() {
            return true;
        }

        public TileEntity create() {
            return this.tileEntitySupplier != null ? this.tileEntitySupplier.get() : null;
        }

        public double getUsage() {
            double d;
            switch (this) {
                case ENRICHMENT_CHAMBER: {
                    d = MekanismConfig.current().usage.enrichmentChamber.val();
                    break;
                }
                case OSMIUM_COMPRESSOR: {
                    d = MekanismConfig.current().usage.osmiumCompressor.val();
                    break;
                }
                case COMBINER: {
                    d = MekanismConfig.current().usage.combiner.val();
                    break;
                }
                case CRUSHER: {
                    d = MekanismConfig.current().usage.crusher.val();
                    break;
                }
                case DIGITAL_MINER: {
                    d = MekanismConfig.current().usage.digitalMiner.val();
                    break;
                }
                case METALLURGIC_INFUSER: {
                    d = MekanismConfig.current().usage.metallurgicInfuser.val();
                    break;
                }
                case PURIFICATION_CHAMBER: {
                    d = MekanismConfig.current().usage.purificationChamber.val();
                    break;
                }
                case ENERGIZED_SMELTER: {
                    d = MekanismConfig.current().usage.energizedSmelter.val();
                    break;
                }
                case TELEPORTER: {
                    d = 12500.0;
                    break;
                }
                case ELECTRIC_PUMP: {
                    d = MekanismConfig.current().usage.electricPump.val();
                    break;
                }
                case PERSONAL_CHEST: {
                    d = 30.0;
                    break;
                }
                case CHARGEPAD: {
                    d = 25.0;
                    break;
                }
                case ROTARY_CONDENSENTRATOR: {
                    d = MekanismConfig.current().usage.rotaryCondensentrator.val();
                    break;
                }
                case CHEMICAL_OXIDIZER: {
                    d = MekanismConfig.current().usage.oxidationChamber.val();
                    break;
                }
                case CHEMICAL_INFUSER: {
                    d = MekanismConfig.current().usage.chemicalInfuser.val();
                    break;
                }
                case CHEMICAL_INJECTION_CHAMBER: {
                    d = MekanismConfig.current().usage.chemicalInjectionChamber.val();
                    break;
                }
                case ELECTROLYTIC_SEPARATOR: {
                    d = MekanismConfig.current().general.FROM_H2.val() * 2.0;
                    break;
                }
                case PRECISION_SAWMILL: {
                    d = MekanismConfig.current().usage.precisionSawmill.val();
                    break;
                }
                case CHEMICAL_DISSOLUTION_CHAMBER: {
                    d = MekanismConfig.current().usage.chemicalDissolutionChamber.val();
                    break;
                }
                case CHEMICAL_WASHER: {
                    d = MekanismConfig.current().usage.chemicalWasher.val();
                    break;
                }
                case CHEMICAL_CRYSTALLIZER: {
                    d = MekanismConfig.current().usage.chemicalCrystallizer.val();
                    break;
                }
                case SEISMIC_VIBRATOR: {
                    d = MekanismConfig.current().usage.seismicVibrator.val();
                    break;
                }
                case PRESSURIZED_REACTION_CHAMBER: {
                    d = MekanismConfig.current().usage.pressurizedReactionBase.val();
                    break;
                }
                case FLUIDIC_PLENISHER: {
                    d = MekanismConfig.current().usage.fluidicPlenisher.val();
                    break;
                }
                case LASER: {
                    d = MekanismConfig.current().usage.laser.val();
                    break;
                }
                case RESISTIVE_HEATER: {
                    d = 100.0;
                    break;
                }
                case FORMULAIC_ASSEMBLICATOR: {
                    d = MekanismConfig.current().usage.formulaicAssemblicator.val();
                    break;
                }
                case ISOTOPIC_CENTRIFUGE: {
                    d = MekanismConfig.current().usage.isotopicCentrifuge.val();
                    break;
                }
                case NUTRITIONAL_LIQUIFIER: {
                    d = MekanismConfig.current().usage.liquifierNutritional.val();
                    break;
                }
                case ORGANIC_FARM: {
                    d = MekanismConfig.current().usage.organicfarm.val();
                    break;
                }
                case ANTIPROTONIC_NUCLEOSYNTHESIZER: {
                    d = MekanismConfig.current().usage.nucleosynthesizer.val();
                    break;
                }
                case STAMPING: {
                    d = MekanismConfig.current().usage.stamping.val();
                    break;
                }
                case ROLLING: {
                    d = MekanismConfig.current().usage.rolling.val();
                    break;
                }
                case BRUSHED: {
                    d = MekanismConfig.current().usage.brushed.val();
                    break;
                }
                case TURNING: {
                    d = MekanismConfig.current().usage.turning.val();
                    break;
                }
                case ALLOY: {
                    d = MekanismConfig.current().usage.alloy.val();
                    break;
                }
                case CELL_EXTRACTOR: {
                    d = MekanismConfig.current().usage.cellExtractor.val();
                    break;
                }
                case CELL_SEPARATOR: {
                    d = MekanismConfig.current().usage.cellSeparator.val();
                    break;
                }
                case RECYCLER: {
                    d = MekanismConfig.current().usage.recycler.val();
                    break;
                }
                case AMBIENT_ACCUMULATOR_ENERGY: {
                    d = MekanismConfig.current().usage.AmbientAccumulatorEnergy.val();
                    break;
                }
                case MODIFICATION_STATION: {
                    d = MekanismConfig.current().usage.modificationStation.val();
                    break;
                }
                default: {
                    d = 0.0;
                }
            }
            return d;
        }

        private double getConfigStorage() {
            double d;
            switch (this) {
                case ENRICHMENT_CHAMBER: {
                    d = MekanismConfig.current().storage.enrichmentChamber.val();
                    break;
                }
                case OSMIUM_COMPRESSOR: {
                    d = MekanismConfig.current().storage.osmiumCompressor.val();
                    break;
                }
                case COMBINER: {
                    d = MekanismConfig.current().storage.combiner.val();
                    break;
                }
                case CRUSHER: {
                    d = MekanismConfig.current().storage.crusher.val();
                    break;
                }
                case DIGITAL_MINER: {
                    d = MekanismConfig.current().storage.digitalMiner.val();
                    break;
                }
                case METALLURGIC_INFUSER: {
                    d = MekanismConfig.current().storage.metallurgicInfuser.val();
                    break;
                }
                case PURIFICATION_CHAMBER: {
                    d = MekanismConfig.current().storage.purificationChamber.val();
                    break;
                }
                case ENERGIZED_SMELTER: {
                    d = MekanismConfig.current().storage.energizedSmelter.val();
                    break;
                }
                case TELEPORTER: {
                    d = MekanismConfig.current().storage.teleporter.val();
                    break;
                }
                case ELECTRIC_PUMP: {
                    d = MekanismConfig.current().storage.electricPump.val();
                    break;
                }
                case CHARGEPAD: {
                    d = MekanismConfig.current().storage.chargePad.val();
                    break;
                }
                case ROTARY_CONDENSENTRATOR: {
                    d = MekanismConfig.current().storage.rotaryCondensentrator.val();
                    break;
                }
                case CHEMICAL_OXIDIZER: {
                    d = MekanismConfig.current().storage.oxidationChamber.val();
                    break;
                }
                case CHEMICAL_INFUSER: {
                    d = MekanismConfig.current().storage.chemicalInfuser.val();
                    break;
                }
                case CHEMICAL_INJECTION_CHAMBER: {
                    d = MekanismConfig.current().storage.chemicalInjectionChamber.val();
                    break;
                }
                case ELECTROLYTIC_SEPARATOR: {
                    d = MekanismConfig.current().storage.electrolyticSeparator.val();
                    break;
                }
                case PRECISION_SAWMILL: {
                    d = MekanismConfig.current().storage.precisionSawmill.val();
                    break;
                }
                case CHEMICAL_DISSOLUTION_CHAMBER: {
                    d = MekanismConfig.current().storage.chemicalDissolutionChamber.val();
                    break;
                }
                case CHEMICAL_WASHER: {
                    d = MekanismConfig.current().storage.chemicalWasher.val();
                    break;
                }
                case CHEMICAL_CRYSTALLIZER: {
                    d = MekanismConfig.current().storage.chemicalCrystallizer.val();
                    break;
                }
                case SEISMIC_VIBRATOR: {
                    d = MekanismConfig.current().storage.seismicVibrator.val();
                    break;
                }
                case PRESSURIZED_REACTION_CHAMBER: {
                    d = MekanismConfig.current().storage.pressurizedReactionBase.val();
                    break;
                }
                case FLUIDIC_PLENISHER: {
                    d = MekanismConfig.current().storage.fluidicPlenisher.val();
                    break;
                }
                case LASER: {
                    d = MekanismConfig.current().storage.laser.val();
                    break;
                }
                case FORMULAIC_ASSEMBLICATOR: {
                    d = MekanismConfig.current().storage.formulaicAssemblicator.val();
                    break;
                }
                case ISOTOPIC_CENTRIFUGE: {
                    d = MekanismConfig.current().storage.isotopicCentrifuge.val();
                    break;
                }
                case NUTRITIONAL_LIQUIFIER: {
                    d = MekanismConfig.current().storage.liquifierNutritional.val();
                    break;
                }
                case ORGANIC_FARM: {
                    d = MekanismConfig.current().storage.organicfarm.val();
                    break;
                }
                case ANTIPROTONIC_NUCLEOSYNTHESIZER: {
                    d = MekanismConfig.current().storage.nucleosynthesizer.val();
                    break;
                }
                case STAMPING: {
                    d = MekanismConfig.current().storage.stamping.val();
                    break;
                }
                case ROLLING: {
                    d = MekanismConfig.current().storage.rolling.val();
                    break;
                }
                case BRUSHED: {
                    d = MekanismConfig.current().storage.brushed.val();
                    break;
                }
                case TURNING: {
                    d = MekanismConfig.current().storage.turning.val();
                    break;
                }
                case ALLOY: {
                    d = MekanismConfig.current().storage.alloy.val();
                    break;
                }
                case CELL_EXTRACTOR: {
                    d = MekanismConfig.current().storage.cellExtractor.val();
                    break;
                }
                case CELL_SEPARATOR: {
                    d = MekanismConfig.current().storage.cellSeparator.val();
                    break;
                }
                case RECYCLER: {
                    d = MekanismConfig.current().storage.recycler.val();
                    break;
                }
                case INDUSTRIAL_ALARM: {
                    d = 0.0;
                    break;
                }
                case AMBIENT_ACCUMULATOR_ENERGY: {
                    d = MekanismConfig.current().storage.AmbientAccumulatorEnergy.val();
                    break;
                }
                case HYBRID_STORAGE: {
                    d = MekanismConfig.current().storage.HybridStorageEnergy.val();
                    break;
                }
                case MODIFICATION_STATION: {
                    d = MekanismConfig.current().storage.modificationStation.val();
                    break;
                }
                default: {
                    d = 400.0 * this.getUsage();
                }
            }
            return d;
        }

        public double getStorage() {
            return Math.max(this.getConfigStorage(), this.getUsage());
        }

        public String getDescription() {
            return LangUtils.localize("tooltip." + this.blockName);
        }

        public ItemStack getStack() {
            return new ItemStack(this.typeBlock.getBlock(), 1, this.meta);
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.func_176610_l();
        }

        public boolean canRotateTo(EnumFacing side) {
            return this.facingPredicate.test(side);
        }

        public boolean hasRotations() {
            return !this.facingPredicate.equals(BlockStateUtils.NO_ROTATION);
        }

        public boolean hasActiveTexture() {
            return this.activable;
        }

        public boolean isFactory() {
            return this.factoryTier != null;
        }

        static {
            VALID_METAS = new EnumMap<MachineBlock, Int2ReferenceMap<MachineType>>(MachineBlock.class);
            Arrays.stream(MachineType.values()).forEach(MachineType::registerType);
            VALID_MACHINES = new ArrayList<MachineType>();
            Arrays.stream(MachineType.values()).filter(MachineType::isValidMachine).forEach(VALID_MACHINES::add);
        }
    }

    public static enum MachineBlock {
        MACHINE_BLOCK_1,
        MACHINE_BLOCK_2,
        MACHINE_BLOCK_3,
        MACHINE_BLOCK_4;

        PropertyEnum<MachineType> machineTypeProperty;

        public PropertyEnum<MachineType> getProperty() {
            if (this.machineTypeProperty == null) {
                this.machineTypeProperty = PropertyEnum.func_177708_a((String)"type", MachineType.class, input -> input != null && input.typeBlock == this && input.isValidMachine());
            }
            return this.machineTypeProperty;
        }

        public Block getBlock() {
            Block block;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case MACHINE_BLOCK_1: {
                    block = MekanismBlocks.MachineBlock;
                    break;
                }
                case MACHINE_BLOCK_2: {
                    block = MekanismBlocks.MachineBlock2;
                    break;
                }
                case MACHINE_BLOCK_3: {
                    block = MekanismBlocks.MachineBlock3;
                    break;
                }
                case MACHINE_BLOCK_4: {
                    block = MekanismBlocks.MachineBlock4;
                }
            }
            return block;
        }
    }
}

