/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.IMekWrench;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStatePlastic;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.wrenches.Wrenches;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPlastic
extends Block {
    public static final Material PLASTIC = new Material(MapColor.field_151667_k);
    public BlockStatePlastic.PlasticBlockType type;

    public BlockPlastic(BlockStatePlastic.PlasticBlockType blockType) {
        super(PLASTIC);
        this.type = blockType;
        this.func_149711_c(this.type == BlockStatePlastic.PlasticBlockType.REINFORCED ? 50.0f : 5.0f);
        this.func_149752_b(this.type == BlockStatePlastic.PlasticBlockType.REINFORCED ? 2000.0f : 10.0f);
        this.func_149647_a(Mekanism.tabMekanismAddition);
        if (this.type == BlockStatePlastic.PlasticBlockType.SLICK) {
            this.field_149765_K = 0.98f;
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStatePlastic(this);
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BlockStatePlastic.colorProperty, (Comparable)EnumDyeColor.func_176766_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BlockStatePlastic.colorProperty)).func_176767_b();
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (this.type == BlockStatePlastic.PlasticBlockType.ROAD) {
            double boost = 1.6;
            double a = Math.atan2(entityIn.field_70159_w, entityIn.field_70179_y);
            entityIn.field_70159_w += Math.sin(a) * boost * (double)this.field_149765_K;
            entityIn.field_70179_y += Math.cos(a) * boost * (double)this.field_149765_K;
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs creativetabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < EnumColor.DYES.length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.type == BlockStatePlastic.PlasticBlockType.GLOW) {
            return 10;
        }
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult raytrace;
        IMekWrench wrenchHandler;
        if (world.field_72995_K) {
            return true;
        }
        ItemStack stack = entityplayer.func_184586_b(hand);
        if (!stack.func_190926_b() && MekanismConfig.current().mekce.PlasticWrench.val() && (wrenchHandler = Wrenches.getHandler(stack)) != null && wrenchHandler.canUseWrench(entityplayer, hand, stack, raytrace = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
            wrenchHandler.wrenchUsed(entityplayer, hand, stack, raytrace);
            if (entityplayer.func_70093_af()) {
                MekanismUtils.dismantleBlock(this, state, world, pos);
                return true;
            }
        }
        return false;
    }
}

