/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasTank;
import mekanism.common.tile.multiblock.TileEntityMultiblock;
import mekanism.common.util.MekanismUtils;
import org.jetbrains.annotations.Nullable;

public abstract class MultiblockGasTank<MULTIBLOCK extends TileEntityMultiblock>
implements IGasTank {
    protected final MULTIBLOCK multiblock;

    protected MultiblockGasTank(MULTIBLOCK multiblock) {
        this.multiblock = multiblock;
    }

    public abstract void setGas(GasStack var1);

    protected abstract void updateValveData();

    @Override
    public int input(@javax.annotation.Nullable GasStack resource, boolean doFill) {
        if (((TileEntityMultiblock)this.multiblock).structure != null && !this.multiblock.func_145831_w().field_72995_K) {
            if (resource == null) {
                return 0;
            }
            GasStack gasStack = this.getGas();
            if (gasStack != null && !gasStack.isGasEqual(resource)) {
                return 0;
            }
            if (gasStack == null) {
                if (resource.amount <= this.getMaxGas()) {
                    if (doFill) {
                        gasStack = resource.copy();
                        this.setGas(gasStack);
                        if (resource.amount > 0) {
                            MekanismUtils.saveChunk(this.multiblock);
                            this.updateValveData();
                        }
                    }
                    return resource.amount;
                }
                if (doFill) {
                    gasStack = resource.copy();
                    this.setGas(gasStack);
                    gasStack.amount = this.getMaxGas();
                    if (this.getMaxGas() > 0) {
                        MekanismUtils.saveChunk(this.multiblock);
                        this.updateValveData();
                    }
                }
                return this.getMaxGas();
            }
            int needed = this.getMaxGas() - gasStack.amount;
            if (resource.amount <= needed) {
                if (doFill) {
                    gasStack.amount += resource.amount;
                    if (resource.amount > 0) {
                        MekanismUtils.saveChunk(this.multiblock);
                        this.updateValveData();
                    }
                }
                return resource.amount;
            }
            if (doFill) {
                gasStack.amount = this.getMaxGas();
                if (needed > 0) {
                    MekanismUtils.saveChunk(this.multiblock);
                    this.updateValveData();
                }
            }
            return needed;
        }
        return 0;
    }

    @Override
    public GasStack output(int maxDrain, boolean doDrain) {
        if (((TileEntityMultiblock)this.multiblock).structure != null && !this.multiblock.func_145831_w().field_72995_K) {
            GasStack gasStack = this.getGas();
            if (gasStack == null || gasStack.amount <= 0) {
                return null;
            }
            int used = maxDrain;
            if (gasStack.amount < used) {
                used = gasStack.amount;
            }
            if (doDrain) {
                gasStack.amount -= used;
            }
            GasStack drained = new GasStack(gasStack.getGas(), used);
            if (gasStack.amount <= 0) {
                this.setGas(null);
            }
            if (drained.amount > 0 && doDrain) {
                MekanismUtils.saveChunk(this.multiblock);
                ((TileEntityMultiblock)this.multiblock).sendPacketToRenderer();
            }
            return drained;
        }
        return null;
    }

    @Override
    public int getGasAmount() {
        if (((TileEntityMultiblock)this.multiblock).structure != null) {
            GasStack fluid = this.getGas();
            return fluid == null ? 0 : fluid.amount;
        }
        return 0;
    }

    @Override
    public GasTankInfo getInfo() {
        return new GasTankInfo(){

            @Override
            @Nullable
            public GasStack getGas() {
                return MultiblockGasTank.this.getGas();
            }

            @Override
            public int getStored() {
                return MultiblockGasTank.this.getGasAmount();
            }

            @Override
            public int getMaxGas() {
                return MultiblockGasTank.this.getMaxGas();
            }
        };
    }
}

