/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.InfuseStorage;
import mekanism.common.MekanismFluids;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.NucleosynthesizerInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.Chance2MachineRecipe;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.FarmMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.machines.NucleosynthesizerRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.prefab.TileEntityFarmMachine;
import mekanism.common.util.LangUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public interface IFactory {
    public int getRecipeType(ItemStack var1);

    @Nullable
    public RecipeType getRecipeTypeOrNull(ItemStack var1);

    public void setRecipeType(int var1, ItemStack var2);

    public static enum RecipeType implements IStringSerializable
    {
        SMELTING("Smelting", "smelter", BlockStateMachine.MachineType.ENERGIZED_SMELTER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.ENERGIZED_SMELTER),
        ENRICHING("Enriching", "enrichment", BlockStateMachine.MachineType.ENRICHMENT_CHAMBER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.ENRICHMENT_CHAMBER),
        CRUSHING("Crushing", "crusher", BlockStateMachine.MachineType.CRUSHER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.CRUSHER),
        COMPRESSING("Compressing", "compressor", BlockStateMachine.MachineType.OSMIUM_COMPRESSOR, MachineFuelType.ADVANCED, false, RecipeHandler.Recipe.OSMIUM_COMPRESSOR),
        COMBINING("Combining", "combiner", BlockStateMachine.MachineType.COMBINER, MachineFuelType.DOUBLE, false, RecipeHandler.Recipe.COMBINER),
        PURIFYING("Purifying", "purifier", BlockStateMachine.MachineType.PURIFICATION_CHAMBER, MachineFuelType.ADVANCED, true, RecipeHandler.Recipe.PURIFICATION_CHAMBER),
        INJECTING("Injecting", "injection", BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER, MachineFuelType.ADVANCED, true, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER),
        INFUSING("Infusing", "metalinfuser", BlockStateMachine.MachineType.METALLURGIC_INFUSER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.METALLURGIC_INFUSER),
        SAWING("Sawing", "sawmill", BlockStateMachine.MachineType.PRECISION_SAWMILL, MachineFuelType.CHANCE, false, RecipeHandler.Recipe.PRECISION_SAWMILL),
        STAMPING("Stamping", "stamping", BlockStateMachine.MachineType.STAMPING, MachineFuelType.BASIC, false, RecipeHandler.Recipe.STAMPING),
        ROLLING("Rolling", "rolling", BlockStateMachine.MachineType.ROLLING, MachineFuelType.BASIC, false, RecipeHandler.Recipe.ROLLING),
        BRUSHED("Brushed", "brushed", BlockStateMachine.MachineType.BRUSHED, MachineFuelType.BASIC, false, RecipeHandler.Recipe.BRUSHED),
        TURNING("Turning", "turning", BlockStateMachine.MachineType.TURNING, MachineFuelType.BASIC, false, RecipeHandler.Recipe.TURNING),
        AllOY("Alloy", "alloy", BlockStateMachine.MachineType.ALLOY, MachineFuelType.DOUBLE, false, RecipeHandler.Recipe.ALLOY),
        EXTRACTOR("Extractor", "extractor", BlockStateMachine.MachineType.CELL_EXTRACTOR, MachineFuelType.CHANCE, false, RecipeHandler.Recipe.CELL_EXTRACTOR),
        SEPARATOR("Separator", "separator", BlockStateMachine.MachineType.CELL_SEPARATOR, MachineFuelType.CHANCE, false, RecipeHandler.Recipe.CELL_SEPARATOR),
        FARM("Farm", "farm", BlockStateMachine.MachineType.ORGANIC_FARM, MachineFuelType.FARM, true, RecipeHandler.Recipe.ORGANIC_FARM),
        RECYCLER("Recycler", "Recycler", BlockStateMachine.MachineType.RECYCLER, MachineFuelType.CHANCE2, false, RecipeHandler.Recipe.RECYCLER),
        Crystallizer("Crystallizer", "crystallizer", BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER, false, false),
        Dissolution("Dissolution", "dissolution", BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER, MachineFuelType.BASIC, true, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER),
        PRC("PRC", "prc", BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER, false, false),
        OXIDIZER("Oxidizer", "oxidizer", BlockStateMachine.MachineType.CHEMICAL_OXIDIZER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.CHEMICAL_OXIDIZER, false, false),
        NUCLEOSYNTHESIZER("Nucleosynthesizer", "nucleosynthesizer", BlockStateMachine.MachineType.ANTIPROTONIC_NUCLEOSYNTHESIZER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.ANTIPROTONIC_NUCLEOSYNTHESIZER, false, false),
        WASHER("Washer", "washer", BlockStateMachine.MachineType.CHEMICAL_WASHER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.CHEMICAL_WASHER, false, false);

        private String name;
        private SoundEvent sound;
        private BlockStateMachine.MachineType type;
        private MachineFuelType fuelType;
        private boolean fuelSpeed;
        private RecipeHandler.Recipe recipe;
        private TileEntityAdvancedElectricMachine AdvancedElectricMachineCacheTile;
        private TileEntityFarmMachine FarmMachineCacheTile;
        public boolean isFullBlock;
        public boolean isOpaqueCube;

        private RecipeType(String s, String s1, BlockStateMachine.MachineType t, MachineFuelType ft, boolean speed, RecipeHandler.Recipe r) {
            this(s, s1, t, ft, speed, r, true, true);
        }

        private RecipeType(String s, String s1, BlockStateMachine.MachineType t, MachineFuelType ft, boolean speed, RecipeHandler.Recipe r, boolean fullBlock, boolean opaque) {
            this.name = s;
            this.sound = new SoundEvent(new ResourceLocation("mekanism", "tile.machine." + s1));
            this.type = t;
            this.fuelType = ft;
            this.fuelSpeed = speed;
            this.recipe = r;
            this.isFullBlock = fullBlock;
            this.isOpaqueCube = opaque;
        }

        public static RecipeType getFromMachine(Block block, int meta) {
            RecipeType type = null;
            for (RecipeType iterType : RecipeType.values()) {
                ItemStack machineStack = iterType.getStack();
                Block machineBlock = Block.func_149634_a((Item)machineStack.func_77973_b());
                int machineMeta = machineStack.func_77952_i();
                if (machineBlock != block || machineMeta != meta) continue;
                type = iterType;
                break;
            }
            return type;
        }

        @Nullable
        public static RecipeType getFromMachineType(BlockStateMachine.MachineType machineType) {
            for (RecipeType type : RecipeType.values()) {
                if (type.type != machineType) continue;
                return type;
            }
            return null;
        }

        public BasicMachineRecipe<?> getRecipe(ItemStackInput input) {
            return (BasicMachineRecipe)RecipeHandler.getRecipe(input, this.recipe);
        }

        public BasicMachineRecipe<?> getRecipe(ItemStack input) {
            return this.getRecipe(new ItemStackInput(input));
        }

        public AdvancedMachineRecipe<?> getRecipe(AdvancedMachineInput input) {
            return (AdvancedMachineRecipe)RecipeHandler.getRecipe(input, this.recipe);
        }

        public AdvancedMachineRecipe<?> getRecipe(ItemStack input, Gas gas) {
            return this.getRecipe(new AdvancedMachineInput(input, gas));
        }

        public DoubleMachineRecipe<?> getRecipe(DoubleMachineInput input) {
            return (DoubleMachineRecipe)RecipeHandler.getRecipe(input, this.recipe);
        }

        public DoubleMachineRecipe<?> getRecipe(ItemStack input, ItemStack extra) {
            return this.getRecipe(new DoubleMachineInput(input, extra));
        }

        public ChanceMachineRecipe<?> getChanceRecipe(ItemStackInput input) {
            return (ChanceMachineRecipe)RecipeHandler.getRecipe(input, this.recipe);
        }

        public ChanceMachineRecipe<?> getChanceRecipe(ItemStack input) {
            return this.getChanceRecipe(new ItemStackInput(input));
        }

        public MetallurgicInfuserRecipe getRecipe(InfusionInput input) {
            return RecipeHandler.getMetallurgicInfuserRecipe(input);
        }

        public MetallurgicInfuserRecipe getRecipe(ItemStack input, InfuseStorage storage) {
            return this.getRecipe(new InfusionInput(storage, input));
        }

        public CrystallizerRecipe getRecipe(GasInput input) {
            return RecipeHandler.getChemicalCrystallizerRecipe(input);
        }

        public CrystallizerRecipe getCrystallizerRecipe(GasStack gas) {
            return this.getRecipe(new GasInput(gas));
        }

        public DissolutionRecipe getDissolutionRecipe(ItemStackInput input) {
            return (DissolutionRecipe)RecipeHandler.getRecipe(input, this.recipe);
        }

        public DissolutionRecipe getDissolutionRecipe(ItemStack input) {
            return this.getDissolutionRecipe(new ItemStackInput(input));
        }

        public OxidationRecipe getOxidationRecipe(ItemStackInput input) {
            return (OxidationRecipe)RecipeHandler.getRecipe(input, this.recipe);
        }

        public OxidationRecipe getOxidationRecipe(ItemStack input) {
            return this.getOxidationRecipe(new ItemStackInput(input));
        }

        public NucleosynthesizerRecipe getNucleosynthesizerRecipe(NucleosynthesizerInput input) {
            return (NucleosynthesizerRecipe)RecipeHandler.getRecipe(input, this.recipe);
        }

        public NucleosynthesizerRecipe getNucleosynthesizerRecipe(ItemStack input, GasStack gas) {
            return this.getNucleosynthesizerRecipe(new NucleosynthesizerInput(input, gas));
        }

        public PressurizedRecipe getPressurizedRecipe(PressurizedInput input) {
            return (PressurizedRecipe)RecipeHandler.getRecipe(input, this.recipe);
        }

        public PressurizedRecipe getPressurizedRecipe(ItemStack input, FluidStack fluid, GasStack gas) {
            return this.getPressurizedRecipe(new PressurizedInput(input, fluid, gas));
        }

        public WasherRecipe getWasherRecipe(GasInput input) {
            return RecipeHandler.getChemicalWasherRecipe(input);
        }

        public WasherRecipe getWasherRecipe(GasStack gas) {
            return this.getWasherRecipe(new GasInput(gas));
        }

        public FarmMachineRecipe<?> getFarmRecipe(AdvancedMachineInput input) {
            return (FarmMachineRecipe)RecipeHandler.getRecipe(input, this.recipe);
        }

        public FarmMachineRecipe<?> getFarmRecipe(ItemStack input, Gas gas) {
            return this.getFarmRecipe(new AdvancedMachineInput(input, gas));
        }

        public Chance2MachineRecipe<?> getChance2Recipe(ItemStackInput input) {
            return (Chance2MachineRecipe)RecipeHandler.getRecipe(input, this.recipe);
        }

        public Chance2MachineRecipe<?> getChance2Recipe(ItemStack input) {
            return this.getChance2Recipe(new ItemStackInput(input));
        }

        @Nullable
        public MachineRecipe getAnyRecipe(ItemStack slotStack, ItemStack extraStack, Gas gasType, InfuseStorage infuse, GasStack gasStackType, FluidStack fluidStack) {
            if (this.fuelType == MachineFuelType.ADVANCED) {
                return this.getRecipe(slotStack, gasType);
            }
            if (this.fuelType == MachineFuelType.DOUBLE) {
                return this.getRecipe(slotStack, extraStack);
            }
            if (this.fuelType == MachineFuelType.CHANCE) {
                return this.getChanceRecipe(slotStack);
            }
            if (this.fuelType == MachineFuelType.FARM) {
                return this.getFarmRecipe(slotStack, gasType);
            }
            if (this.fuelType == MachineFuelType.CHANCE2) {
                return this.getChance2Recipe(slotStack);
            }
            if (this == Crystallizer) {
                return this.getCrystallizerRecipe(gasStackType);
            }
            if (this == Dissolution) {
                return this.getDissolutionRecipe(slotStack);
            }
            if (this == PRC) {
                return this.getPressurizedRecipe(slotStack, fluidStack, gasStackType);
            }
            if (this == OXIDIZER) {
                return this.getOxidationRecipe(slotStack);
            }
            if (this == NUCLEOSYNTHESIZER) {
                return this.getNucleosynthesizerRecipe(slotStack, gasStackType);
            }
            if (this == WASHER) {
                return this.getWasherRecipe(gasStackType);
            }
            if (this == INFUSING) {
                if (infuse.getType() != null) {
                    return RecipeHandler.getMetallurgicInfuserRecipe(new InfusionInput(infuse, slotStack));
                }
                for (Map.Entry entry : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().entrySet()) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)((InfusionInput)entry.getKey()).inputStack, (ItemStack)slotStack)) continue;
                    return (MachineRecipe)entry.getValue();
                }
            }
            return this.getRecipe(slotStack);
        }

        public int getSecondaryEnergyPerTick() {
            if (this.fuelType == MachineFuelType.ADVANCED) {
                return this.getTile().BASE_SECONDARY_ENERGY_PER_TICK;
            }
            if (this.fuelType == MachineFuelType.FARM) {
                return this.getTile2().BASE_SECONDARY_ENERGY_PER_TICK;
            }
            return 0;
        }

        public boolean canReceiveGas(EnumFacing side, Gas type) {
            if (this.fuelType == MachineFuelType.ADVANCED) {
                return this.getTile().canReceiveGas(side, type);
            }
            if (this.fuelType == MachineFuelType.FARM) {
                return this.getTile2().canReceiveGas(side, type);
            }
            return false;
        }

        public boolean isValidGas(Gas gas) {
            if (this.fuelType == MachineFuelType.ADVANCED) {
                return this.getTile().isValidGas(gas);
            }
            if (this.fuelType == MachineFuelType.FARM) {
                return this.getTile2().isValidGas(gas);
            }
            if (this == Crystallizer) {
                return RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.containsRecipe(gas);
            }
            if (this == Dissolution) {
                return gas == MekanismFluids.SulfuricAcid;
            }
            if (this == PRC) {
                return RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.containsRecipe(gas);
            }
            if (this == WASHER) {
                return RecipeHandler.Recipe.CHEMICAL_WASHER.containsRecipe(gas);
            }
            if (this == NUCLEOSYNTHESIZER) {
                return RecipeHandler.Recipe.ANTIPROTONIC_NUCLEOSYNTHESIZER.containsRecipe(gas);
            }
            return false;
        }

        public boolean hasRecipe(ItemStack itemStack) {
            if (itemStack.func_190926_b()) {
                return false;
            }
            for (Object obj : this.recipe.get().entrySet()) {
                Object k = ((Map.Entry)obj).getKey();
                if (!(k instanceof AdvancedMachineInput)) continue;
                AdvancedMachineInput input = (AdvancedMachineInput)k;
                ItemStack stack = input.itemStack;
                if (!StackUtils.equalsWildcard(stack, itemStack)) continue;
                return true;
            }
            return false;
        }

        public boolean hasRecipeForExtra(ItemStack extraStack) {
            if (extraStack.func_190926_b()) {
                return false;
            }
            for (Object obj : this.recipe.get().entrySet()) {
                Object k = ((Map.Entry)obj).getKey();
                if (!(k instanceof DoubleMachineInput)) continue;
                DoubleMachineInput input = (DoubleMachineInput)k;
                ItemStack stack = input.extraStack;
                if (!StackUtils.equalsWildcard(stack, extraStack)) continue;
                return true;
            }
            return false;
        }

        public TileEntityAdvancedElectricMachine getTile() {
            if (this.AdvancedElectricMachineCacheTile == null) {
                BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(this.getStack());
                this.AdvancedElectricMachineCacheTile = (TileEntityAdvancedElectricMachine)type.create();
            }
            return this.AdvancedElectricMachineCacheTile;
        }

        public TileEntityFarmMachine getTile2() {
            if (this.FarmMachineCacheTile == null) {
                BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(this.getStack());
                this.FarmMachineCacheTile = (TileEntityFarmMachine)type.create();
            }
            return this.FarmMachineCacheTile;
        }

        public double getEnergyUsage() {
            return this.type.getUsage();
        }

        public double getEnergyStorage() {
            return this.type.getStorage();
        }

        public ItemStack getStack() {
            return this.type.getStack();
        }

        public String getTranslationKey() {
            return this.name;
        }

        public String getLocalizedName() {
            return LangUtils.localize("gui.factory." + this.name);
        }

        public SoundEvent getSound() {
            return this.sound;
        }

        public MachineFuelType getFuelType() {
            return this.fuelType;
        }

        public boolean fuelEnergyUpgrades() {
            return this.fuelSpeed;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public BlockStateMachine.MachineType getType() {
            return this.type;
        }

        public RecipeHandler.Recipe getrecipe() {
            return this.recipe;
        }
    }

    public static enum MachineFuelType {
        BASIC,
        ADVANCED,
        DOUBLE,
        CHANCE,
        FARM,
        CHANCE2;

    }
}

