/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import cofh.redstoneflux.api.IEnergyReceiver;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.function.Function;
import mekanism.api.Coord4D;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.fluxnetworks.FluxPlugAcceptor;
import mekanism.common.integration.forgeenergy.ForgeEnergyIntegration;
import mekanism.common.integration.ic2.IC2Integration;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.integration.tesla.TeslaIntegration;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import sonar.fluxnetworks.common.tileentity.TileFluxPlug;

public abstract class EnergyAcceptorWrapper
implements IStrictEnergyAcceptor {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mekanism EnergyAcceptorWrapper");
    public Coord4D coord;

    public static EnergyAcceptorWrapper get(TileEntity tileEntity, EnumFacing side) {
        if (tileEntity == null || tileEntity.func_145831_w() == null) {
            return null;
        }
        EnergyAcceptorWrapper wrapper = EnergyAcceptorWrapper.getAccepterWrapper(tileEntity, side);
        if (wrapper != null) {
            wrapper.coord = Coord4D.get(tileEntity);
        }
        return wrapper;
    }

    @Nullable
    private static EnergyAcceptorWrapper getAccepterWrapper(TileEntity tileEntity, EnumFacing side) {
        IEnergyTile tile;
        EnergyAcceptorWrapper wrapper = EnergyAcceptorWrapper.fromCapability(tileEntity, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, side, MekanismAcceptor::new);
        if (wrapper != null) {
            return wrapper;
        }
        if (MekanismUtils.useTesla()) {
            wrapper = EnergyAcceptorWrapper.fromCapability(tileEntity, Capabilities.TESLA_CONSUMER_CAPABILITY, side, TeslaAcceptor::new);
        }
        if (wrapper != null) {
            return wrapper;
        }
        if (MekanismUtils.useForge()) {
            wrapper = EnergyAcceptorWrapper.fromCapability(tileEntity, CapabilityEnergy.ENERGY, side, ForgeAcceptor::new);
        }
        if (wrapper != null) {
            return wrapper;
        }
        if (MekanismUtils.useRF() && tileEntity instanceof IEnergyReceiver) {
            IEnergyReceiver energyReceiver = (IEnergyReceiver)tileEntity;
            wrapper = new RFAcceptor(energyReceiver);
        }
        if (wrapper != null) {
            return wrapper;
        }
        if (MekanismUtils.useIC2() && (tile = EnergyNet.instance.getSubTile(tileEntity.func_145831_w(), tileEntity.func_174877_v())) instanceof IEnergySink) {
            IEnergySink sink = (IEnergySink)tile;
            wrapper = new IC2Acceptor(sink);
        }
        if (wrapper != null) {
            return wrapper;
        }
        if (MekanismUtils.useFlux() && tileEntity instanceof TileFluxPlug) {
            TileFluxPlug plug = (TileFluxPlug)tileEntity;
            wrapper = new FluxPlugAcceptor(plug, side);
        }
        return wrapper;
    }

    @Nullable
    private static <T> EnergyAcceptorWrapper fromCapability(TileEntity tileEntity, Capability<T> capability, EnumFacing side, Function<T, EnergyAcceptorWrapper> makeAcceptor) {
        T acceptor = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, capability, side);
        if (acceptor != null) {
            return makeAcceptor.apply(acceptor);
        }
        return null;
    }

    public abstract boolean needsEnergy(EnumFacing var1);

    public static class RFAcceptor
    extends EnergyAcceptorWrapper {
        private IEnergyReceiver acceptor;

        public RFAcceptor(IEnergyReceiver rfAcceptor) {
            this.acceptor = rfAcceptor;
        }

        @Override
        public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
            return RFIntegration.fromRF(this.acceptor.receiveEnergy(side, RFIntegration.toRF(amount), simulate));
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.canConnectEnergy(side);
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.receiveEnergy(side, 1, true) > 0;
        }
    }

    public static class IC2Acceptor
    extends EnergyAcceptorWrapper {
        private IEnergySink acceptor;

        public IC2Acceptor(IEnergySink ic2Acceptor) {
            this.acceptor = ic2Acceptor;
        }

        @Override
        public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
            double toTransfer = Math.min(this.acceptor.getDemandedEnergy(), IC2Integration.toEU(amount));
            if (simulate) {
                return IC2Integration.fromEU(toTransfer);
            }
            double rejects = this.acceptor.injectEnergy(side, toTransfer, 0.0);
            return IC2Integration.fromEU(toTransfer - rejects);
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.acceptsEnergyFrom(null, side);
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.getDemandedEnergy() > 0.0;
        }
    }

    public static class ForgeAcceptor
    extends EnergyAcceptorWrapper {
        private IEnergyStorage acceptor;

        public ForgeAcceptor(IEnergyStorage forgeConsumer) {
            this.acceptor = forgeConsumer;
        }

        @Override
        public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
            return ForgeEnergyIntegration.fromForge(this.acceptor.receiveEnergy(ForgeEnergyIntegration.toForge(amount), simulate));
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.canReceive();
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.receiveEnergy(1, true) > 0;
        }
    }

    public static class TeslaAcceptor
    extends EnergyAcceptorWrapper {
        private ITeslaConsumer acceptor;

        public TeslaAcceptor(ITeslaConsumer teslaConsumer) {
            this.acceptor = teslaConsumer;
        }

        @Override
        public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
            return TeslaIntegration.fromTesla(this.acceptor.givePower(TeslaIntegration.toTesla(amount), simulate));
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.givePower(1L, true) > 0L;
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.canReceiveEnergy(side);
        }
    }

    public static class MekanismAcceptor
    extends EnergyAcceptorWrapper {
        private IStrictEnergyAcceptor acceptor;

        public MekanismAcceptor(IStrictEnergyAcceptor mekAcceptor) {
            this.acceptor = mekAcceptor;
        }

        @Override
        public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
            return this.acceptor.acceptEnergy(side, amount, simulate);
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.canReceiveEnergy(side);
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.acceptEnergy(side, 1.0, true) > 0.0;
        }
    }
}

