/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.EnumColor;
import mekanism.common.MekanismItems;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public enum Upgrade {
    SPEED("speed", MekanismConfig.current().mekce.MAXSpeedUpgrade.val(), MekanismConfig.current().mekce.MAXSpeedUpgradeSize.val(), EnumColor.RED),
    ENERGY("energy", MekanismConfig.current().mekce.MAXEnergyUpgrade.val(), MekanismConfig.current().mekce.MAXEnergyUpgradeSize.val(), EnumColor.BRIGHT_GREEN),
    FILTER("filter", 1, 1, EnumColor.DARK_AQUA),
    GAS("gas", MekanismConfig.current().mekce.MAXGasUpgrade.val(), MekanismConfig.current().mekce.MAXGasUpgradeSize.val(), EnumColor.YELLOW),
    MUFFLING("muffling", MekanismConfig.current().mekce.MAXMufflingUpgrade.val(), MekanismConfig.current().mekce.MAXMufflingUpgradeSize.val(), EnumColor.DARK_GREY),
    ANCHOR("anchor", 1, 1, EnumColor.DARK_GREEN),
    STONE_GENERATOR("stonegenerator", 1, 1, EnumColor.ORANGE),
    THREAD("thread", MekanismConfig.current().mekce.MAXThreadUpgrade.val(), MekanismConfig.current().mekce.MAXThreadUpgradeSize.val(), EnumColor.ORANGE);

    private String name;
    private int maxStack;
    private int maxItemStack;
    private EnumColor color;

    private Upgrade(String s, int max, int maxItem, EnumColor c) {
        this.name = s;
        this.maxStack = max;
        this.maxItemStack = maxItem;
        this.color = c;
    }

    public static Map<Upgrade, Integer> buildMap(@Nullable NBTTagCompound nbtTags) {
        EnumMap<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
        if (nbtTags != null && nbtTags.func_74764_b("upgrades")) {
            NBTTagList list = nbtTags.func_150295_c("upgrades", 10);
            for (int tagCount = 0; tagCount < list.func_74745_c(); ++tagCount) {
                NBTTagCompound compound = list.func_150305_b(tagCount);
                Upgrade upgrade = Upgrade.values()[compound.func_74762_e("type")];
                upgrades.put(upgrade, compound.func_74762_e("amount"));
            }
        }
        return upgrades;
    }

    public static void saveMap(Map<Upgrade, Integer> upgrades, NBTTagCompound nbtTags) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
            list.func_74742_a((NBTBase)Upgrade.getTagFor(entry.getKey(), entry.getValue()));
        }
        nbtTags.func_74782_a("upgrades", (NBTBase)list);
    }

    public static NBTTagCompound getTagFor(Upgrade upgrade, int amount) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("type", upgrade.ordinal());
        compound.func_74768_a("amount", amount);
        return compound;
    }

    public String getName() {
        return LangUtils.localize("upgrade." + this.name);
    }

    public String getDescription() {
        return LangUtils.localize("upgrade." + this.name + ".desc");
    }

    public int getItemMax() {
        return this.maxItemStack;
    }

    public int getMax() {
        return this.maxStack;
    }

    public EnumColor getColor() {
        return this.color;
    }

    public boolean canMultiply() {
        return this.getMax() > 1;
    }

    public ItemStack getStack() {
        ItemStack itemStack;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SPEED: {
                itemStack = new ItemStack(MekanismItems.SpeedUpgrade);
                break;
            }
            case ENERGY: {
                itemStack = new ItemStack(MekanismItems.EnergyUpgrade);
                break;
            }
            case FILTER: {
                itemStack = new ItemStack(MekanismItems.FilterUpgrade);
                break;
            }
            case MUFFLING: {
                itemStack = new ItemStack(MekanismItems.MufflingUpgrade);
                break;
            }
            case GAS: {
                itemStack = new ItemStack(MekanismItems.GasUpgrade);
                break;
            }
            case ANCHOR: {
                itemStack = new ItemStack(MekanismItems.AnchorUpgrade);
                break;
            }
            case STONE_GENERATOR: {
                itemStack = new ItemStack(MekanismItems.StoneGeneratorUpgrade);
                break;
            }
            case THREAD: {
                itemStack = new ItemStack(MekanismItems.ThreadUpgrade);
            }
        }
        return itemStack;
    }

    public List<String> getInfo(TileEntity tile) {
        List<String> ret = new ArrayList<String>();
        if (tile instanceof IUpgradeTile) {
            IUpgradeTile upgradeTile = (IUpgradeTile)tile;
            if (tile instanceof IUpgradeInfoHandler) {
                IUpgradeInfoHandler handler = (IUpgradeInfoHandler)tile;
                return handler.getInfo(this);
            }
            ret = this.getMultScaledInfo(upgradeTile);
        }
        return ret;
    }

    public List<String> getMultScaledInfo(IUpgradeTile tile) {
        ArrayList<String> ret = new ArrayList<String>();
        Upgrade upgrade = this;
        if (this.canMultiply()) {
            if (MekanismConfig.current().mekce.EnableUpgradeConfigure.val()) {
                double effect = upgrade == ENERGY ? MekanismUtils.capacity(tile) : (upgrade == SPEED ? MekanismUtils.time(tile) : Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), (float)tile.getComponent().getUpgrades(upgrade) / (float)this.getMax()));
                ret.add(LangUtils.localize("gui.upgrades.effect") + ": " + MekanismUtils.exponential(effect) + "x");
            } else {
                double effect = Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), (float)tile.getComponent().getUpgrades(this) / (float)this.getMax());
                ret.add(LangUtils.localize("gui.upgrades.effect") + ": " + (float)Math.round(effect * 100.0) / 100.0f + "x");
            }
        }
        return ret;
    }

    public List<String> getExpScaledInfo(IUpgradeTile tile) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.canMultiply()) {
            if (MekanismConfig.current().mekce.EnableUpgradeConfigure.val()) {
                ret.add(LangUtils.localize("gui.upgrades.effect") + ": " + MekanismUtils.time(tile) + "x");
            } else {
                double effect = Math.min(Math.pow(2.0, tile.getComponent().getUpgrades(this)), (double)MekanismConfig.current().mekce.MAXspeedmachines.val());
                ret.add(LangUtils.localize("gui.upgrades.effect") + ": " + effect + "x");
            }
        }
        return ret;
    }

    public static interface IUpgradeInfoHandler {
        public List<String> getInfo(Upgrade var1);
    }
}

