/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.ArrayList;
import mekanism.api.EnumColor;
import mekanism.api.gas.GasTank;
import mekanism.common.base.ITankManager;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.LangUtils;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class SideData {
    public EnumColor color;
    public String name;
    public int[] availableSlots;
    public boolean[] allowExtractionSlot;
    public IOState ioState;

    public SideData(int[] slots, boolean[] extractionSlot) {
        this(DataType.INPUT_OUTPUT, slots, extractionSlot);
    }

    public SideData(DataType dataType, int[] slots, boolean[] extractionSlot) {
        this(dataType, slots);
        this.allowExtractionSlot = extractionSlot;
    }

    public SideData(DataType dataType, int[] slots) {
        this.name = dataType.getName();
        this.color = dataType.getColor();
        this.availableSlots = slots;
    }

    public SideData(DataType dataType, IOState state) {
        this.name = dataType.getName();
        this.color = dataType.getColor();
        this.ioState = state;
    }

    public String localize() {
        return LangUtils.localize("sideData." + this.name);
    }

    public boolean hasSlot(int ... slots) {
        for (int i : this.availableSlots) {
            for (int slot : slots) {
                if (i != slot) continue;
                return true;
            }
        }
        return false;
    }

    public FluidTankInfo[] getFluidTankInfo(ITankManager manager) {
        Object[] tanks = manager.getTanks();
        ArrayList<FluidTankInfo> infos = new ArrayList<FluidTankInfo>();
        if (tanks == null) {
            return infos.toArray(new FluidTankInfo[0]);
        }
        for (int slot : this.availableSlots) {
            Object object;
            if (slot > tanks.length - 1 || !((object = tanks[slot]) instanceof IFluidTank)) continue;
            IFluidTank tank = (IFluidTank)object;
            infos.add(tank.getInfo());
        }
        return infos.toArray(new FluidTankInfo[0]);
    }

    public GasTank getGasTank(ITankManager manager) {
        Object object;
        Object[] tanks = manager.getTanks();
        if (tanks == null || tanks.length < 1 || !((object = tanks[0]) instanceof GasTank)) {
            return null;
        }
        GasTank gasTank = (GasTank)object;
        return gasTank;
    }

    public static enum IOState {
        INPUT,
        OUTPUT,
        OFF;

    }
}

